/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.jira.config.FeatureFlag;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

class FeatureFlagParser {
    FeatureFlagParser() {
    }

    static Set<FeatureFlag> parseFlags(Element descriptorE) {
        HashSet flags = Sets.newHashSet();
        List flagElements = descriptorE.elements("flag");
        for (Element e : flagElements) {
            String key = e.attributeValue("key");
            boolean defaultState = FeatureFlagParser.parseDefault(e.attributeValue("default", "false"));
            if (!StringUtils.isNotEmpty((CharSequence)key)) continue;
            FeatureFlag featureFlag = FeatureFlag.featureFlag((String)key).defaultedTo(defaultState);
            flags.add(featureFlag);
        }
        return flags;
    }

    private static boolean parseDefault(String s) {
        return s != null && ("true".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s));
    }
}

