/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.BackingPropertySetManager;
import com.atlassian.jira.config.properties.DbBackedNotCachedPropertySetManager;
import com.atlassian.jira.config.properties.DbBackedPropertySetManager;
import com.atlassian.jira.config.properties.ZDUDbBackedCachedPropertySetManager;
import com.google.common.base.Preconditions;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.module.propertyset.memory.MemoryPropertySet;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemorySwitchToDatabaseBackedPropertiesManager
implements BackingPropertySetManager {
    private static final Logger log = LoggerFactory.getLogger(MemorySwitchToDatabaseBackedPropertiesManager.class);
    private final AtomicReference<MemoryPropertySet> memoryPropertySetRef;
    private final AtomicReference<DbBackedPropertySetManager> dbBackingPropertySetManagerAtomicRef;

    public MemorySwitchToDatabaseBackedPropertiesManager() {
        MemoryPropertySet memoryPropertySet = new MemoryPropertySet();
        memoryPropertySet.init(Collections.emptyMap(), Collections.emptyMap());
        this.memoryPropertySetRef = new AtomicReference<MemoryPropertySet>(memoryPropertySet);
        this.dbBackingPropertySetManagerAtomicRef = new AtomicReference<Object>(null);
    }

    private void switchToDbMode() {
        Preconditions.checkState((this.memoryPropertySetRef.get() != null && this.dbBackingPropertySetManagerAtomicRef.get() == null ? 1 : 0) != 0, (Object)"Assuming switching from in memory mode to DB mode but already in DB mode.");
        log.info("Switching from in-memory property set to database property set.");
        DbBackedPropertySetManager dbBackingPropertySetManager = MemorySwitchToDatabaseBackedPropertiesManager.getDbBackingPropertySetManager();
        PropertySetManager.clone((PropertySet)((PropertySet)this.memoryPropertySetRef.get()), (PropertySet)((PropertySet)dbBackingPropertySetManager.getPropertySetSupplier().get()));
        this.dbBackingPropertySetManagerAtomicRef.set(dbBackingPropertySetManager);
        this.memoryPropertySetRef.set(null);
    }

    private static DbBackedPropertySetManager getDbBackingPropertySetManager() {
        Optional dbBackingPropertySetManager = ComponentAccessor.getComponentSafely(ZDUDbBackedCachedPropertySetManager.class);
        if (dbBackingPropertySetManager.isPresent()) {
            return (DbBackedPropertySetManager)dbBackingPropertySetManager.get();
        }
        return (DbBackedPropertySetManager)ComponentAccessor.getComponent(DbBackedNotCachedPropertySetManager.class);
    }

    public synchronized void refresh() {
        MemoryPropertySet memoryPropertySet = this.memoryPropertySetRef.get();
        if (memoryPropertySet != null) {
            memoryPropertySet.remove();
            this.switchBackingStore();
        } else {
            DbBackedPropertySetManager dbBackingPropertySetManager = this.dbBackingPropertySetManagerAtomicRef.get();
            dbBackingPropertySetManager.refresh();
        }
    }

    public synchronized void switchBackingStore() {
        this.switchToDbMode();
    }

    public Supplier<? extends PropertySet> getPropertySetSupplier() {
        return () -> {
            MemoryPropertySet memoryPropertySet = this.memoryPropertySetRef.get();
            if (memoryPropertySet != null) {
                return memoryPropertySet;
            }
            return (PropertySet)this.dbBackingPropertySetManagerAtomicRef.get().getPropertySetSupplier().get();
        };
    }
}

