/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.jira.util.stats.LastValueSerializableStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import java.util.concurrent.atomic.AtomicLong;

public interface GroupDaoStats
extends ManagedStats {
    @Override
    default public String getStatsName() {
        return "GROUP-DAO-STATS";
    }

    public static GroupDaoStats create() {
        return new MutableGroupDaoStats();
    }

    public void settings(boolean var1, boolean var2);

    public void findByNameOrNull();

    public void findByNameOrNullCacheHit();

    public void findByNameOrNullCacheMiss();

    public void findByNameOrNullDBHit(long var1);

    public void findByNameOrNullDBMiss(long var1);

    public void findGroupsGenericValue(long var1);

    public void groupAddFailed();

    public void groupAddFailedUpdateSuccessful();

    public void groupAddFailedUpdateFailed();

    public static class MutableGroupDaoStats
    implements GroupDaoStats {
        final LastValueSerializableStats<Boolean> eager = new LastValueSerializableStats();
        final LastValueSerializableStats<Boolean> findByNameOrNullSkipRefreshOnNull = new LastValueSerializableStats();
        final AtomicLong findByNameOrNull = new AtomicLong();
        final AtomicLong findByNameOrNullCacheHit = new AtomicLong();
        final AtomicLong findByNameOrNullCacheMiss = new AtomicLong();
        final MutableLongStats findByNameOrNullDBHitInMilliseconds = new MutableLongStats(1L, 10L, 50L, 100L, 500L, 1000L, 5000L, 10000L);
        final MutableLongStats findByNameOrNullDBMissInMilliseconds = new MutableLongStats(1L, 10L, 50L, 100L, 500L, 1000L, 5000L, 10000L);
        final MutableLongStats findGroupsGenericValueInMilliseconds = new MutableLongStats(1L, 10L, 50L, 100L, 500L, 1000L, 5000L, 10000L);
        final AtomicLong groupAddFailed = new AtomicLong();
        final AtomicLong groupAddFailedUpdateSuccessful = new AtomicLong();
        final AtomicLong groupAddFailedUpdateFailed = new AtomicLong();

        @Override
        public void settings(boolean eager, boolean findByNameOrNullSkipRefreshOnNull) {
            this.eager.store(eager);
            this.findByNameOrNullSkipRefreshOnNull.store(findByNameOrNullSkipRefreshOnNull);
        }

        @Override
        public void findByNameOrNull() {
            this.findByNameOrNull.incrementAndGet();
        }

        @Override
        public void findByNameOrNullCacheHit() {
            this.findByNameOrNullCacheHit.incrementAndGet();
        }

        @Override
        public void findByNameOrNullCacheMiss() {
            this.findByNameOrNullCacheMiss.incrementAndGet();
        }

        @Override
        public void findByNameOrNullDBHit(long elapsedMillis) {
            this.findByNameOrNullDBHitInMilliseconds.accept(elapsedMillis);
        }

        @Override
        public void findByNameOrNullDBMiss(long elapsedMillis) {
            this.findByNameOrNullDBMissInMilliseconds.accept(elapsedMillis);
        }

        @Override
        public void findGroupsGenericValue(long elapsedMillis) {
            this.findGroupsGenericValueInMilliseconds.accept(elapsedMillis);
        }

        @Override
        public void groupAddFailed() {
            this.groupAddFailed.incrementAndGet();
        }

        @Override
        public void groupAddFailedUpdateSuccessful() {
            this.groupAddFailedUpdateSuccessful.incrementAndGet();
        }

        @Override
        public void groupAddFailedUpdateFailed() {
            this.groupAddFailedUpdateFailed.incrementAndGet();
        }
    }
}

