/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.BoundedCount;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroup;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.exception.DataAccessException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizDelegatingMembershipDao
implements MembershipDao {
    private static final Logger LOG = LoggerFactory.getLogger(OfBizDelegatingMembershipDao.class);
    private final InternalMembershipDao membershipDao;
    private final OfBizGroupDao groupDao;
    private final ExtendedUserDao userDao;

    public OfBizDelegatingMembershipDao(InternalMembershipDao membershipDao, ExtendedUserDao userDao, GroupDao groupDao) {
        this.membershipDao = membershipDao;
        this.groupDao = (OfBizGroupDao)groupDao;
        this.userDao = userDao;
    }

    private static List<String> getNames(List<? extends UserOrGroupStub> list) {
        return list.stream().map(DirectoryEntity::getName).collect(Collectors.toList());
    }

    public BatchResult<String> addAllUsersToGroup(long directoryId, Collection<String> userNames, String groupName) throws GroupNotFoundException {
        BatchResult allResults = new BatchResult(userNames.size());
        ArrayList<UserOrGroupStub> users = new ArrayList<UserOrGroupStub>(userNames.size());
        for (String userName : userNames) {
            try {
                OfBizUser user = this.userDao.findByNameOrNull(directoryId, userName);
                if (user != null) {
                    users.add(user);
                    continue;
                }
                allResults.addFailure((Object)userName);
                LOG.debug("User '{}' not found", (Object)userName);
            }
            catch (DataAccessException e) {
                allResults.addFailure((Object)userName);
                LOG.debug("Data error trying to resolve user '{}'", (Object)userName, (Object)e);
            }
        }
        if (!users.isEmpty()) {
            OfBizGroup group = this.groupDao.findOfBizGroup(directoryId, groupName);
            BatchResult<String> delegateResults = this.membershipDao.addAllUsersToGroup(directoryId, users, group);
            allResults.addFailures((Collection)delegateResults.getFailedEntities());
            allResults.addSuccesses((Collection)delegateResults.getSuccessfulEntities());
        }
        return allResults;
    }

    public boolean isUserDirectMember(long directoryId, String userName, String groupName) {
        return this.membershipDao.isUserDirectMember(directoryId, userName, groupName);
    }

    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        return this.membershipDao.isGroupDirectMember(directoryId, childGroup, parentGroup);
    }

    public void addUserToGroup(long directoryId, String user, String group) throws UserNotFoundException, GroupNotFoundException, MembershipAlreadyExistsException {
        OfBizUser idUser = this.userDao.findOfBizUser(directoryId, user);
        OfBizGroup idGroup = this.groupDao.findOfBizGroup(directoryId, group);
        this.membershipDao.addUserToGroup(directoryId, idUser, idGroup);
    }

    public void addGroupToGroup(long directoryId, String child, String parent) throws GroupNotFoundException {
        OfBizGroup idChild = this.groupDao.findOfBizGroup(directoryId, child);
        OfBizGroup idParent = this.groupDao.findOfBizGroup(directoryId, parent);
        this.membershipDao.addGroupToGroup(directoryId, idChild, idParent);
    }

    public void removeUserFromGroup(long directoryId, String user, String group) throws UserNotFoundException, GroupNotFoundException, MembershipNotFoundException {
        OfBizUser idUser = this.userDao.findOfBizUser(directoryId, user);
        OfBizGroup idGroup = this.groupDao.findOfBizGroup(directoryId, group);
        this.membershipDao.removeUserFromGroup(directoryId, idUser, idGroup);
    }

    public void removeGroupFromGroup(long directoryId, String child, String parent) throws GroupNotFoundException, MembershipNotFoundException {
        OfBizGroup idChild = this.groupDao.findOfBizGroup(directoryId, child);
        OfBizGroup idParent = this.groupDao.findOfBizGroup(directoryId, parent);
        this.membershipDao.removeGroupFromGroup(directoryId, idChild, idParent);
    }

    public <T> List<T> search(long directoryId, MembershipQuery<T> query) {
        return this.result(directoryId, query, this.membershipDao.search(directoryId, query));
    }

    public <T> ListMultimap<String, T> searchGroupedByName(long directoryId, MembershipQuery<T> query) {
        return this.resultGroupedByName(directoryId, query, this.membershipDao.searchGroupedByName(directoryId, query));
    }

    private <T> ListMultimap<String, T> resultGroupedByName(long directoryId, MembershipQuery<T> query, ListMultimap<String, String> entityNamesGroupedByName) {
        ArrayListMultimap result = ArrayListMultimap.create();
        entityNamesGroupedByName.asMap().forEach((arg_0, arg_1) -> this.lambda$resultGroupedByName$0((ListMultimap)result, directoryId, query, arg_0, arg_1));
        return result;
    }

    public BoundedCount countDirectMembersOfGroup(long directoryId, String groupName, int potentialMaxCount) {
        return BoundedCount.exactly((long)this.membershipDao.countDirectMembersOfGroup(directoryId, groupName, MembershipType.GROUP_USER));
    }

    public BatchResult<String> addUserToGroups(long directoryId, String username, Set<String> groupNames) throws UserNotFoundException {
        BatchResult combinedResults = new BatchResult(groupNames.size());
        OfBizUser user = this.userDao.findOfBizUser(directoryId, username);
        ArrayList<UserOrGroupStub> groups = new ArrayList<UserOrGroupStub>();
        for (String groupName : groupNames) {
            OfBizGroup group = this.groupDao.findByNameOrNull(directoryId, groupName);
            if (group == null) {
                LOG.debug("Attempted to add a user '{}' to a group '{}' but the group does not exist.", (Object)username, (Object)groupName);
                combinedResults.addFailure((Object)groupName);
                continue;
            }
            if (this.isUserDirectMember(directoryId, username, groupName)) {
                LOG.debug("Attempted to add a user '{}' to a group '{}' but the user is already a member of this group.", (Object)username, (Object)groupName);
                combinedResults.addFailure((Object)groupName);
                continue;
            }
            groups.add(group);
        }
        BatchResult<String> result = this.membershipDao.addUserToGroups(directoryId, user, groups);
        combinedResults.addSuccesses((Collection)result.getSuccessfulEntities());
        combinedResults.addFailures((Collection)result.getFailedEntities());
        return combinedResults;
    }

    private <T> List<T> result(long directoryId, MembershipQuery<T> query, List<String> entityNames) throws IllegalStateException {
        if (query.getReturnType().isAssignableFrom(String.class)) {
            return this.doNameQuery(directoryId, entityNames, query.getEntityToReturn());
        }
        if (query.getReturnType().isAssignableFrom(OfBizUser.class)) {
            return this.doUserQuery(directoryId, entityNames);
        }
        if (query.getReturnType().isAssignableFrom(OfBizGroup.class)) {
            return this.doGroupQuery(directoryId, entityNames);
        }
        throw new IllegalArgumentException("Class type '" + query.getReturnType() + "' for return values is not 'String', 'User' or 'Group'");
    }

    private List<OfBizGroup> doGroupQuery(long directoryId, List<String> entityNames) {
        ArrayList<OfBizGroup> groups = new ArrayList<OfBizGroup>(entityNames.size());
        for (String groupName : entityNames) {
            OfBizGroup group = this.groupDao.findByNameOrNull(directoryId, groupName);
            if (group == null) continue;
            groups.add(group);
        }
        return groups;
    }

    private List<OfBizUser> doUserQuery(long directoryId, List<String> entityNames) {
        return this.userDao.findAllByNameOrNull(directoryId, entityNames);
    }

    private List<String> doNameQuery(long directoryId, List<String> entityNames, EntityDescriptor descriptor) {
        if (descriptor.equals((Object)EntityDescriptor.user())) {
            return OfBizDelegatingMembershipDao.getNames(this.doUserQuery(directoryId, entityNames));
        }
        if (descriptor.equals((Object)EntityDescriptor.group())) {
            return OfBizDelegatingMembershipDao.getNames(this.doGroupQuery(directoryId, entityNames));
        }
        return Collections.emptyList();
    }

    private /* synthetic */ void lambda$resultGroupedByName$0(ListMultimap result, long directoryId, MembershipQuery query, String key, Collection values) {
        result.putAll((Object)key, this.result(directoryId, query, (List<String>)ImmutableList.copyOf((Collection)values)));
    }
}

