/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryAttributeEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryOperationEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizDirectory;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizTransactionManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizDirectoryDao
implements DirectoryDao {
    private static final Logger log = LoggerFactory.getLogger(OfBizDirectoryDao.class);
    private static final int SYNCHRONIZATION_ATTRIBUTES_NO = 4;
    private final OfBizDelegator ofBizDelegator;
    private final OfBizTransactionManager ofBizTransactionManager;
    private final CachedReference<List<Directory>> directoryCache;
    private final Object monitor = new Object();

    public OfBizDirectoryDao(OfBizDelegator ofBizDelegator, OfBizTransactionManager ofBizTransactionManager, CacheManager cacheManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.ofBizTransactionManager = ofBizTransactionManager;
        this.directoryCache = this.buildReference(cacheManager);
    }

    private CachedReference<List<Directory>> buildReference(CacheManager cacheManager) {
        return cacheManager.getCachedReference(OfBizDirectoryDao.class, "directoryCache", this::getAllDirectories);
    }

    public Directory findById(long id) throws DirectoryNotFoundException {
        for (Directory directory : (List)this.directoryCache.get()) {
            if (directory.getId() != id) continue;
            return directory;
        }
        throw new DirectoryNotFoundException(Long.valueOf(id));
    }

    public Directory findByName(String name) throws DirectoryNotFoundException {
        for (Directory directory : (List)this.directoryCache.get()) {
            if (!directory.getName().equalsIgnoreCase(name)) continue;
            return directory;
        }
        throw new DirectoryNotFoundException(name);
    }

    public List<Directory> findAll() {
        return (List)this.directoryCache.get();
    }

    private Directory buildDirectory(GenericValue directoryGenericValue) {
        List<GenericValue> attributesGenericValues = this.findAttributesGenericValues(directoryGenericValue.getLong("id"));
        List<GenericValue> operationGenericValues = this.findOperations(directoryGenericValue.getLong("id"));
        if (attributesGenericValues.isEmpty()) {
            log.warn(String.format("Reading attributes of directory [%d] from the database returned 0 values", directoryGenericValue.getLong("id")), (Throwable)new RuntimeException());
        }
        return OfBizDirectory.from(directoryGenericValue, attributesGenericValues, operationGenericValues);
    }

    private List<GenericValue> findAttributesGenericValues(long directoryId) {
        return this.ofBizDelegator.findByAnd("DirectoryAttribute", PrimitiveMap.of("directoryId", directoryId));
    }

    private List<GenericValue> findOperations(long directoryId) {
        return this.ofBizDelegator.findByAnd("DirectoryOperation", PrimitiveMap.of("directoryId", directoryId));
    }

    private GenericValue findDirectoryById(Long id) throws DirectoryNotFoundException {
        try {
            GenericValue directoryGenericValue = EntityUtil.getOnly(this.findDirectories(PrimitiveMap.of("id", id)));
            if (directoryGenericValue != null) {
                return directoryGenericValue;
            }
            throw new DirectoryNotFoundException(id);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private List<GenericValue> findDirectories(Map<String, Object> filter) throws GenericEntityException {
        return this.ofBizDelegator.findByAnd("Directory", filter);
    }

    public Directory add(Directory directory) {
        DirectoryImpl directoryToSave = new DirectoryImpl(directory);
        Object object = this.monitor;
        synchronized (object) {
            long directoryId;
            try {
                GenericValue genericValue;
                directoryToSave.setCreatedDateToNow();
                directoryToSave.setUpdatedDateToNow();
                Map<String, Object> map = DirectoryEntity.getData((Directory)directoryToSave);
                GenericValue directoryGenericValue = this.ofBizDelegator.createValue("Directory", map);
                directoryId = directoryGenericValue.getLong("id");
                for (Map.Entry entry : directory.getAttributes().entrySet()) {
                    genericValue = this.ofBizDelegator.makeValue("DirectoryAttribute", DirectoryAttributeEntity.getData(directoryId, (String)entry.getKey(), (String)entry.getValue()));
                    genericValue.create();
                }
                for (OperationType operationType : directory.getAllowedOperations()) {
                    genericValue = this.ofBizDelegator.makeValue("DirectoryOperation", DirectoryOperationEntity.getData(directoryId, operationType));
                    genericValue.create();
                }
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
            this.removeDirectoryContents(directoryId);
            this.flushCache();
            try {
                this.updateDirectoryPosition(directoryId, ((List)this.directoryCache.get()).size());
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
            try {
                return this.findById(directoryId);
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory update(Directory directory) throws DirectoryNotFoundException {
        DirectoryImpl updatedDirectory = new DirectoryImpl(directory);
        Object object = this.monitor;
        synchronized (object) {
            GenericValue gv = DirectoryEntity.setData((Directory)updatedDirectory, this.findDirectoryById(directory.getId()));
            gv.set("updatedDate", (Object)new Timestamp(System.currentTimeMillis()));
            this.storeDirectory(gv);
            this.storeAttributes((Directory)updatedDirectory);
            this.storeOperations((Directory)updatedDirectory);
            this.directoryCache.reset();
            return this.findById(updatedDirectory.getId());
        }
    }

    private void storeAttributes(Directory directory) {
        Map localAttributes = directory.getAttributes();
        this.checkIfCorruptedAndLog(directory, localAttributes);
        HashMap<String, String> remoteAttributes = new HashMap<String, String>();
        this.findAttributesGenericValues(directory.getId()).forEach(attribute -> remoteAttributes.put(attribute.getString("name"), attribute.getString("value")));
        ArrayList<GenericValue> newAttributes = new ArrayList<GenericValue>();
        HashMap<String, String> changedAttributes = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : localAttributes.entrySet()) {
            if (this.isNewAttribute(entry, remoteAttributes)) {
                newAttributes.add(this.ofBizDelegator.makeValue("DirectoryAttribute", DirectoryAttributeEntity.getData(directory.getId(), entry.getKey(), entry.getValue())));
                continue;
            }
            String remoteAttributeValue = (String)remoteAttributes.get(entry.getKey());
            if (StringUtils.equals((CharSequence)entry.getValue(), (CharSequence)remoteAttributeValue)) continue;
            changedAttributes.put(entry.getKey(), entry.getValue());
        }
        this.ofBizDelegator.storeAll(newAttributes);
        changedAttributes.forEach((name, value) -> this.ofBizDelegator.bulkUpdateByAnd("DirectoryAttribute", PrimitiveMap.of("value", value), PrimitiveMap.of("directoryId", (long)directory.getId(), "name", name)));
    }

    private boolean isNewAttribute(Map.Entry<String, String> localAttribute, Map<String, String> remoteAttributes) {
        return !remoteAttributes.containsKey(localAttribute.getKey());
    }

    private void checkIfCorruptedAndLog(Directory directory, Map<String, String> attributes) {
        if (attributes.size() <= 4) {
            log.warn(String.format("Attempting to store directory [%d] with only %d attributes", directory.getId(), attributes.size()), (Throwable)new RuntimeException());
        }
    }

    private void storeOperations(Directory directory) {
        Set allowedOperations = directory.getAllowedOperations();
        ArrayList<GenericValue> operationGenericValues = new ArrayList<GenericValue>(allowedOperations.size());
        for (OperationType operationType : allowedOperations) {
            operationGenericValues.add(this.ofBizDelegator.makeValue("DirectoryOperation", DirectoryOperationEntity.getData(directory.getId(), operationType)));
        }
        this.ofBizTransactionManager.withTransaction(t -> {
            this.ofBizDelegator.removeByAnd("DirectoryOperation", PrimitiveMap.of("directoryId", directory.getId()));
            this.ofBizDelegator.storeAll(operationGenericValues);
        });
    }

    private GenericValue storeDirectory(GenericValue directoryGenericValue) {
        this.ofBizDelegator.store(directoryGenericValue);
        return directoryGenericValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Directory directory) throws DirectoryNotFoundException {
        Object object = this.monitor;
        synchronized (object) {
            long directoryId = directory.getId();
            this.findDirectoryById(directoryId);
            this.removeDirectoryContents(directory.getId());
            this.ofBizDelegator.removeByAnd("DirectoryAttribute", PrimitiveMap.of("directoryId", directoryId));
            this.ofBizDelegator.removeByAnd("DirectoryOperation", PrimitiveMap.of("directoryId", directoryId));
            this.ofBizDelegator.removeByAnd("Directory", PrimitiveMap.of("id", directoryId));
            this.directoryCache.reset();
        }
    }

    private void removeDirectoryContents(long directoryId) {
        this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.of("directoryId", directoryId));
        this.ofBizDelegator.removeByAnd("UserAttribute", PrimitiveMap.of("directoryId", directoryId));
        this.ofBizDelegator.removeByAnd("User", PrimitiveMap.of("directoryId", directoryId));
        this.ofBizDelegator.removeByAnd("GroupAttribute", PrimitiveMap.of("directoryId", directoryId));
        this.ofBizDelegator.removeByAnd("Group", PrimitiveMap.of("directoryId", directoryId));
    }

    public List<Directory> search(EntityQuery<Directory> query) {
        Validate.isTrue((Objects.isNull(query) || query.getEntityDescriptor().getEntityType() == Entity.DIRECTORY ? 1 : 0) != 0, (String)"DirectoryDao can only evaluate EntityQueries for Entity.DIRECTORY", (Object[])new Object[0]);
        if (query == null || query.getSearchRestriction() == null || query.getSearchRestriction() instanceof NullRestriction) {
            return (List)this.directoryCache.get();
        }
        if (query.getSearchRestriction() instanceof TermRestriction) {
            TermRestriction termRestriction = (TermRestriction)query.getSearchRestriction();
            Property property = termRestriction.getProperty();
            if (!property.getPropertyName().equals("name")) {
                throw new UnsupportedOperationException("Searching on '" + property.getPropertyName() + "' not supported.");
            }
            MatchMode matchMode = termRestriction.getMatchMode();
            switch (matchMode) {
                case EXACTLY_MATCHES: {
                    return this.searchByName((String)termRestriction.getValue());
                }
            }
            throw new UnsupportedOperationException("Unsupported MatchMode " + matchMode);
        }
        throw new UnsupportedOperationException("Complex Directory searching is not supported.");
    }

    private List<Directory> searchByName(String value) {
        ArrayList<Directory> results = new ArrayList<Directory>(1);
        for (Directory directory : (List)this.directoryCache.get()) {
            if (!directory.getName().equals(value)) continue;
            results.add(directory);
        }
        return results;
    }

    private List<Directory> getAllDirectories() {
        ImmutableList.Builder directories = ImmutableList.builder();
        List directoryGenericValues = this.ofBizDelegator.findByAnd("Directory", Collections.emptyMap(), Collections.singletonList("position"));
        for (GenericValue directoryGenericValue : directoryGenericValues) {
            directories.add((Object)this.buildDirectory(directoryGenericValue));
        }
        return directories.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        Object object = this.monitor;
        synchronized (object) {
            this.directoryCache.reset();
        }
    }

    public void updateDirectoryPosition(long directoryId, int position) throws DirectoryNotFoundException {
        ArrayList<Directory> directories = new ArrayList<Directory>(this.findAll());
        int currentPos = this.getCurrentDirectoryPosition(directories, directoryId);
        if (currentPos == -1) {
            throw new IllegalArgumentException("Directory to set position of does not exist");
        }
        if (position != currentPos) {
            Directory directory = (Directory)directories.remove(currentPos);
            if (position < 0) {
                position = 0;
            } else if (position > directories.size()) {
                position = directories.size();
            }
            directories.add(position, directory);
            this.resequenceDirectories(directories);
        }
        this.flushCache();
    }

    private int getCurrentDirectoryPosition(List<Directory> directories, long directoryId) {
        for (int i = 0; i < directories.size(); ++i) {
            if (!directories.get(i).getId().equals(directoryId)) continue;
            return i;
        }
        return -1;
    }

    private void resequenceDirectories(List<Directory> directories) throws DirectoryNotFoundException {
        long i = 0L;
        for (Directory directory : directories) {
            this.storeDirectoryPosition(directory.getId(), i);
            ++i;
        }
    }

    private void storeDirectoryPosition(Long id, long position) throws DirectoryNotFoundException {
        GenericValue gv = this.findDirectoryById(id);
        gv.set("position", (Object)position);
        this.storeDirectory(gv);
    }
}

