/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeCompleteFormatter;
import com.atlassian.jira.datetime.DateTimeDateFormatter;
import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeFormatterServiceProvider;
import com.atlassian.jira.datetime.DateTimeTimeFormatter;
import com.atlassian.jira.datetime.JodaFormatterSupplier;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

abstract class AbstractDateTimeRelativeDatesFormatter
implements DateTimeFormatStrategy {
    private final ApplicationProperties applicationProperties;
    private final Clock clock;
    private final DateTimeFormatterServiceProvider serviceProvider;
    private final DateTimeFormatStrategy dateFormatter;
    private final DateTimeFormatStrategy timeFormatter;
    private final DateTimeFormatStrategy completeFormatter;

    AbstractDateTimeRelativeDatesFormatter(DateTimeFormatterServiceProvider serviceProvider, ApplicationProperties applicationProperties, JodaFormatterSupplier jodaFormatterSupplier, Clock clock) {
        this.applicationProperties = applicationProperties;
        this.clock = clock;
        this.serviceProvider = serviceProvider;
        this.dateFormatter = new DateTimeDateFormatter(serviceProvider, jodaFormatterSupplier);
        this.timeFormatter = new DateTimeTimeFormatter(serviceProvider, jodaFormatterSupplier);
        this.completeFormatter = new DateTimeCompleteFormatter(serviceProvider, jodaFormatterSupplier);
    }

    @Override
    public String format(DateTime theDate, Locale locale) {
        boolean formatterRelative = this.applicationProperties.getOption("jira.lf.date.relativize");
        DateTime referenceDate = new DateTime((Object)this.clock.getCurrentDate(), theDate.getZone());
        long daysDiff = this.calculateDaysDifference(theDate, referenceDate);
        if (!formatterRelative || Math.abs(daysDiff) > 7L) {
            if (this.isFormatAbsoluteWithTime()) {
                return this.formatDateTime(theDate, locale);
            }
            return this.formatDateAbsolute(theDate, locale);
        }
        String relativeDate = this.formatDateRelative(theDate, referenceDate, locale);
        if (!this.isFormatRelativeWithTime() || daysDiff == 0L) {
            return relativeDate;
        }
        return String.format("%s %s", relativeDate, this.formatTime(theDate, locale));
    }

    @Override
    public Date parse(String text, DateTimeZone timeZone, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String pattern() {
        throw new UnsupportedOperationException();
    }

    abstract boolean isFormatRelativeWithTime();

    abstract boolean isFormatAbsoluteWithTime();

    private long calculateDaysDifference(DateTime theDate, DateTime referenceDate) {
        DateTime theDateStartOfDay = theDate.withTimeAtStartOfDay();
        DateTime referenceDateStartOfDay = referenceDate.withTimeAtStartOfDay();
        return Days.daysBetween((ReadableInstant)theDateStartOfDay, (ReadableInstant)referenceDateStartOfDay).getDays();
    }

    private String formatDateTime(DateTime theDate, Locale locale) {
        return this.completeFormatter.format(theDate, locale);
    }

    private String formatDateAbsolute(DateTime theDate, Locale locale) {
        return this.dateFormatter.format(theDate, locale);
    }

    private String formatDateRelative(DateTime theDate, DateTime referenceDate, Locale locale) {
        long daysDiff = this.calculateDaysDifference(theDate, referenceDate);
        if (daysDiff == 0L) {
            return this.formatToday(theDate, referenceDate);
        }
        if (daysDiff >= -7L && daysDiff <= 7L) {
            return this.formatFromLastToNextWeek(daysDiff);
        }
        return this.dateFormatter.format(theDate, locale);
    }

    private String formatTime(DateTime theDate, Locale locale) {
        return this.timeFormatter.format(theDate, locale);
    }

    private String formatToday(DateTime theDate, DateTime referenceDate) {
        boolean isPast;
        long seconds = Seconds.secondsBetween((ReadableInstant)theDate, (ReadableInstant)referenceDate).getSeconds();
        long minutesAbsolute = Math.abs(TimeUnit.SECONDS.toMinutes(seconds));
        long hoursAbsolute = Math.abs(TimeUnit.SECONDS.toHours(seconds));
        boolean bl = isPast = seconds >= 0L;
        if (isPast) {
            if (minutesAbsolute == 0L) {
                return this.getText("common.date.relative.a.moment.ago", new Object[0]);
            }
            if (minutesAbsolute == 1L) {
                return this.getText("common.date.relative.one.minute.ago", new Object[0]);
            }
            if (minutesAbsolute <= 59L) {
                return this.getText("common.date.relative.x.minutes.ago", minutesAbsolute);
            }
            if (hoursAbsolute == 1L) {
                return this.getText("common.date.relative.one.hour.ago", new Object[0]);
            }
            return this.getText("common.date.relative.x.hours.ago", hoursAbsolute);
        }
        if (minutesAbsolute == 0L) {
            return this.getText("common.date.relative.in.a.moment", new Object[0]);
        }
        if (minutesAbsolute == 1L) {
            return this.getText("common.date.relative.in.one.minute", new Object[0]);
        }
        if (minutesAbsolute <= 59L) {
            return this.getText("common.date.relative.in.x.minutes", minutesAbsolute);
        }
        if (hoursAbsolute == 1L) {
            return this.getText("common.date.relative.in.one.hour", new Object[0]);
        }
        return this.getText("common.date.relative.in.x.hours", hoursAbsolute);
    }

    private String formatFromLastToNextWeek(long daysDiff) {
        boolean isFuture = daysDiff < 0L;
        long absoluteDaysDiff = Math.abs(daysDiff);
        if (absoluteDaysDiff > 7L) {
            return null;
        }
        if (isFuture) {
            return this.formatFutureUpToNextWeek(absoluteDaysDiff);
        }
        return this.formatPastUntilLastWeek(absoluteDaysDiff);
    }

    private String formatPastUntilLastWeek(long absoluteDaysDiff) {
        if (absoluteDaysDiff == 1L) {
            return this.getText("common.concepts.yesterday", "").trim();
        }
        if (absoluteDaysDiff < 7L) {
            return this.getText("common.date.relative.x.days.ago", absoluteDaysDiff);
        }
        return this.getText("common.date.relative.one.week.ago", new Object[0]);
    }

    private String formatFutureUpToNextWeek(long absoluteDaysDiff) {
        if (absoluteDaysDiff == 1L) {
            return this.getText("common.concepts.tomorrow", "").trim();
        }
        if (absoluteDaysDiff < 7L) {
            return this.getText("common.date.relative.in.x.days", absoluteDaysDiff);
        }
        return this.getText("common.date.relative.in.one.week", new Object[0]);
    }

    private String getText(String i18nKey, Object ... params) {
        return new MessageFormat(this.serviceProvider.getUnescapedText(i18nKey)).format(params);
    }
}

