/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import java.util.Date;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.text.StringEscapeUtils;

@Immutable
public class DateTimeVelocityUtils {
    private final DateTimeFormatter dateTimeFormatter;

    public DateTimeVelocityUtils(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter != null ? dateTimeFormatter.forLoggedInUser() : null;
    }

    public String formatDMYHMS(Date date) {
        return StringEscapeUtils.escapeHtml4((String)this.dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE).format(date));
    }

    public String formatDMY(Date date) {
        return StringEscapeUtils.escapeHtml4((String)this.dateTimeFormatter.forLoggedInUser().withSystemZone().withStyle(DateTimeStyle.DATE).format(date));
    }

    public String formatTime(Date date) {
        return StringEscapeUtils.escapeHtml4((String)this.dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.TIME).format(date));
    }

    public String formatRSS(Date date) {
        return StringEscapeUtils.escapeXml11((String)this.dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.RSS_RFC822_DATE_TIME).format(date));
    }
}

