/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.diagnostic;

import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.diagnostic.UserDirectoryDataCollector;
import com.atlassian.jira.model.querydsl.DirectoryDTO;
import com.atlassian.jira.model.querydsl.QDirectory;
import com.atlassian.jira.model.querydsl.QGroup;
import com.atlassian.jira.model.querydsl.QMembership;
import com.atlassian.jira.model.querydsl.QUser;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultUserDirectoryDataCollector
implements UserDirectoryDataCollector {
    private final QueryDslAccessor queryDsl;

    public DefaultUserDirectoryDataCollector(QueryDslAccessor queryDsl) {
        this.queryDsl = queryDsl;
    }

    @Override
    public Map<Long, UserDirectoryDataCollector.DirectoryConfiguration> getDirectoriesConfiguration() {
        return this.queryDsl.executeQuery(db -> ((SQLQuery)db.newSqlQuery().select((Expression)QDirectory.DIRECTORY).from((Expression)QDirectory.DIRECTORY)).fetch()).stream().collect(Collectors.toMap(DirectoryDTO::getId, dto -> new UserDirectoryDataCollector.DirectoryConfiguration(dto.getImplementationClass(), dto.getType())));
    }

    @Override
    public Map<Long, Long> getUserCounts() {
        return this.queryDsl.executeQuery(db -> ((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QUser.USER.directoryId, QUser.USER.id.count()}).from((Expression)QUser.USER)).groupBy(QUser.USER.directoryId)).fetch()).stream().collect(Collectors.toMap(c -> (Long)c.get(QUser.USER.directoryId), c -> (Long)c.get(1, Long.class)));
    }

    @Override
    public Map<Long, Long> getGroupCounts() {
        return this.queryDsl.executeQuery(db -> ((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QGroup.GROUP.directoryId, QGroup.GROUP.id.count()}).from((Expression)QGroup.GROUP)).groupBy(QGroup.GROUP.directoryId)).fetch()).stream().collect(Collectors.toMap(c -> (Long)c.get(QGroup.GROUP.directoryId), c -> (Long)c.get(1, Long.class)));
    }

    @Override
    public Map<Long, Long> getMemberships() {
        return this.queryDsl.executeQuery(db -> ((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QMembership.MEMBERSHIP.directoryId, QMembership.MEMBERSHIP.membershipType, QMembership.MEMBERSHIP.id.count()}).from((Expression)QMembership.MEMBERSHIP)).where((Predicate)QMembership.MEMBERSHIP.membershipType.like(MembershipType.GROUP_USER.name()))).groupBy(new Expression[]{QMembership.MEMBERSHIP.directoryId, QMembership.MEMBERSHIP.membershipType})).fetch()).stream().collect(Collectors.toMap(c -> (Long)c.get(QMembership.MEMBERSHIP.directoryId), c -> (Long)c.get(2, Long.class)));
    }
}

