/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.entity.EntityBuilder;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.SelectQuery;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Visitor;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class SelectQueryImpl<E>
implements SelectQuery<E> {
    private final boolean distinct;
    private final Collection<String> fieldsToSelect;
    private final String entityName;
    private final EntityBuilder<E> entityBuilder;
    private final FieldMap whereEqual;
    private final List<EntityCondition> whereCondition;
    private final List<String> orderBy;
    private final int offset;
    private final int maxResults;

    public SelectQueryImpl(Select.QueryBuilder<E> builder) {
        this.distinct = builder.distinct;
        this.fieldsToSelect = builder.fieldsToSelect;
        this.entityName = builder.entityName;
        this.entityBuilder = builder.entityBuilder;
        this.whereEqual = builder.whereEqual;
        this.whereCondition = builder.whereCondition;
        this.orderBy = builder.orderBy;
        this.offset = builder.offset;
        this.maxResults = builder.maxResults;
    }

    @Override
    public SelectQuery.ExecutionContext<E> runWith(OfBizDelegator ofBizDelegator) {
        return new ExecutionContextImpl<E>(ofBizDelegator, this.entityBuilder);
    }

    @Override
    public SelectQuery.ExecutionContext<E> runWith(EntityEngine entityEngine) {
        return entityEngine.run(this);
    }

    private EntityCondition getWhereEntityCondition() {
        if (this.whereCondition == null) {
            if (this.whereEqual == null) {
                return null;
            }
            return new EntityFieldMap((Map)this.whereEqual, EntityOperator.AND);
        }
        if (this.whereEqual == null) {
            return new EntityConditionList(this.whereCondition, EntityOperator.AND);
        }
        ArrayList<Object> conditions = new ArrayList<Object>(this.whereCondition.size() + 1);
        conditions.add(new EntityFieldMap((Map)this.whereEqual, EntityOperator.AND));
        conditions.addAll(this.whereCondition);
        return new EntityConditionList(conditions, EntityOperator.AND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectQueryImpl that = (SelectQueryImpl)o;
        if (this.distinct != that.distinct) {
            return false;
        }
        if (this.maxResults != that.maxResults) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (this.entityBuilder != null ? !this.entityBuilder.equals(that.entityBuilder) : that.entityBuilder != null) {
            return false;
        }
        if (this.entityName != null ? !this.entityName.equals(that.entityName) : that.entityName != null) {
            return false;
        }
        if (this.fieldsToSelect != null ? !this.fieldsToSelect.equals(that.fieldsToSelect) : that.fieldsToSelect != null) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
            return false;
        }
        if (this.whereCondition != null ? !this.whereCondition.equals(that.whereCondition) : that.whereCondition != null) {
            return false;
        }
        return !(this.whereEqual != null ? !this.whereEqual.equals((Object)that.whereEqual) : that.whereEqual != null);
    }

    public int hashCode() {
        int result = this.distinct ? 1 : 0;
        result = 31 * result + (this.fieldsToSelect != null ? this.fieldsToSelect.hashCode() : 0);
        result = 31 * result + (this.entityName != null ? this.entityName.hashCode() : 0);
        result = 31 * result + (this.entityBuilder != null ? this.entityBuilder.hashCode() : 0);
        result = 31 * result + (this.whereEqual != null ? this.whereEqual.hashCode() : 0);
        result = 31 * result + (this.whereCondition != null ? this.whereCondition.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        result = 31 * result + this.offset;
        result = 31 * result + this.maxResults;
        return result;
    }

    public String toString() {
        return "SelectQueryImpl[distinct=" + this.distinct + ",fieldsToSelect=" + this.fieldsToSelect + ",entityName=" + this.entityName + ",entityBuilder=" + this.entityBuilder + ",whereEqual=" + this.whereEqual + ",whereCondition=" + this.whereCondition + ",orderBy=" + this.orderBy + ",offset=" + this.offset + ",maxResults=" + this.maxResults + ']';
    }

    public final class ExecutionContextImpl<E>
    implements SelectQuery.ExecutionContext<E> {
        private OfBizDelegator ofBizDelegator;
        private final EntityBuilder<E> entityBuilder;

        public ExecutionContextImpl(OfBizDelegator ofBizDelegator, EntityBuilder<E> entityBuilder) {
            this.ofBizDelegator = ofBizDelegator;
            this.entityBuilder = entityBuilder;
        }

        @Override
        @Nonnull
        public List<E> asList() {
            ArrayList list = new ArrayList();
            this.forEach(list::add);
            return list;
        }

        @Override
        @Nonnull
        public <R> List<R> asList(@Nonnull Function<E, R> mappingFunction) {
            ArrayList list = new ArrayList();
            this.forEach(entity -> list.add(mappingFunction.apply(entity)));
            return list;
        }

        @Override
        @Nonnull
        public <K, V> Map<K, V> asMap(@Nonnull Function<E, K> keyMapper, @Nonnull Function<E, V> valueMapper) {
            HashMap map = Maps.newHashMap();
            this.forEach(entity -> map.put(keyMapper.apply(entity), valueMapper.apply(entity)));
            return map;
        }

        @Override
        public void visitWith(@Nonnull Visitor<E> visitor) {
            this.forEach(arg_0 -> visitor.visit(arg_0));
        }

        @Override
        @Nullable
        public E singleValue() throws IllegalStateException {
            return (E)this.consumeWith(new EntityListConsumer<E, E>(){
                private E value = null;
                private boolean found = false;

                @Override
                public void consume(E entity) {
                    if (this.found) {
                        throw new IllegalStateException("Too many rows found for query on " + SelectQueryImpl.this.entityName + "\n\trow1: " + this.value + "row2: \n\t" + entity);
                    }
                    this.value = entity;
                    this.found = true;
                }

                @Override
                public E result() {
                    return this.value;
                }
            });
        }

        @Override
        public <R> R consumeWith(@Nonnull EntityListConsumer<E, R> consumer) {
            this.forEach(consumer::consume);
            return consumer.result();
        }

        @Override
        public void forEach(@Nonnull Consumer<E> consumer) {
            EntityFindOptions entityFindOptions = new EntityFindOptions();
            entityFindOptions.setDistinct(SelectQueryImpl.this.distinct);
            entityFindOptions.setOffset(SelectQueryImpl.this.offset);
            entityFindOptions.setMaxResults(SelectQueryImpl.this.maxResults);
            try (OfBizListIterator ofBizListIterator = this.ofBizDelegator.findListIteratorByCondition(SelectQueryImpl.this.entityName, SelectQueryImpl.this.getWhereEntityCondition(), null, SelectQueryImpl.this.fieldsToSelect, SelectQueryImpl.this.orderBy, entityFindOptions);){
                for (GenericValue genericValue : ofBizListIterator) {
                    consumer.accept(this.entityBuilder.build(genericValue));
                }
            }
        }

        @Override
        public long count() {
            EntityFindOptions entityFindOptions = new EntityFindOptions();
            entityFindOptions.setDistinct(SelectQueryImpl.this.distinct);
            try {
                return this.ofBizDelegator.getDelegatorInterface().countByCondition(SelectQueryImpl.this.entityName, null, SelectQueryImpl.this.getWhereEntityCondition(), entityFindOptions);
            }
            catch (GenericEntityException gee) {
                throw new DataAccessException((Throwable)gee);
            }
        }

        public String toString() {
            return "ExecutionContextImpl[" + SelectQueryImpl.this + ']';
        }
    }
}

