/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.earlystartup;

import com.atlassian.analytics.api.events.AnalyticsPluginReadyEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.earlystartup.DeferredAnalyticsEventService;
import com.atlassian.jira.health.analytics.AbstractHeliumAnalyticsEvent;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.startup.mode.StartupMode;
import com.atlassian.jira.startup.mode.StartupModeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;

@EventComponent
@ParametersAreNonnullByDefault
public class DeferredAnalyticsEventServiceImpl
implements DeferredAnalyticsEventService {
    private static List<Object> events = new ArrayList<Object>();
    private final EventPublisher eventPublisher;
    private final Supplier<Optional<StartupModeReference>> startupModeReferenceSupplier;

    public DeferredAnalyticsEventServiceImpl(EventPublisher eventPublisher) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.startupModeReferenceSupplier = ComponentAccessor.safeSupplierOf(StartupModeReference.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(Object event) {
        Class<DeferredAnalyticsEventServiceImpl> clazz = DeferredAnalyticsEventServiceImpl.class;
        synchronized (DeferredAnalyticsEventServiceImpl.class) {
            if (events == null) {
                this.publishEvent(event);
            } else {
                events.add(event);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onAnalyticsPluginReadyEvent(AnalyticsPluginReadyEvent event) {
        Class<DeferredAnalyticsEventServiceImpl> clazz = DeferredAnalyticsEventServiceImpl.class;
        synchronized (DeferredAnalyticsEventServiceImpl.class) {
            events.forEach(this::publishEvent);
            events = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private AbstractHeliumAnalyticsEvent.LicenseType getLicenseType() {
        JiraLicenseService jiraLicenseService = (JiraLicenseService)ComponentAccessor.getComponent(JiraLicenseService.class);
        return StreamSupport.stream(jiraLicenseService.getLicenses().spliterator(), false).anyMatch(LicenseDetails::isDataCenter) ? AbstractHeliumAnalyticsEvent.LicenseType.DC : AbstractHeliumAnalyticsEvent.LicenseType.SERVER;
    }

    private void publishEvent(Object event) {
        if (event instanceof AbstractHeliumAnalyticsEvent) {
            AbstractHeliumAnalyticsEvent heliumEvent = (AbstractHeliumAnalyticsEvent)event;
            heliumEvent.setStartupMode(this.startupModeReferenceSupplier.get().map(StartupModeReference::get).orElse(StartupMode.UNKNOWN));
            heliumEvent.setLicenseType(this.getLicenseType());
        }
        this.eventPublisher.publish(event);
    }
}

