/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.commit.OnCommitEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEventBuilder;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.event.operation.SpanningOperationHolder;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ImportUtils;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class IssueEventDispatcher {
    public static void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser) {
        IssueEventDispatcher.dispatchEvent(eventTypeId, issue, new HashMap(), remoteUser);
    }

    public static void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, boolean sendMail) {
        IssueEventDispatcher.dispatchEvent(eventTypeId, issue, new HashMap(), remoteUser, sendMail);
    }

    public static void dispatchEvent(Long eventTypeId, Issue issue, Map params, ApplicationUser remoteUser) {
        Map<String, Object> copyOfParams = IssueEventDispatcher.copyParams(params);
        IssueEventDispatcher.putBaseUrlIntoPlay(copyOfParams);
        IssueEventDispatcher.dispatchEvent(new IssueEvent(issue, remoteUser, null, null, null, copyOfParams, eventTypeId, true, false, IssueEventDispatcher.getSpanningOperation()));
    }

    public static void dispatchEvent(Long eventTypeId, Issue issue, Map params, ApplicationUser remoteUser, boolean sendMail) {
        Map<String, Object> copyOfParams = IssueEventDispatcher.copyParams(params);
        IssueEventDispatcher.putBaseUrlIntoPlay(copyOfParams);
        IssueEventDispatcher.dispatchEvent(new IssueEvent(issue, remoteUser, null, null, null, copyOfParams, eventTypeId, sendMail, false, IssueEventDispatcher.getSpanningOperation()));
    }

    public static void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog) {
        HashMap<String, Object> copyOfParams = new HashMap<String, Object>();
        IssueEventDispatcher.putBaseUrlIntoPlay(copyOfParams);
        IssueEventDispatcher.dispatchEvent(eventTypeId, issue, remoteUser, comment, worklog, changelog, copyOfParams);
    }

    public static void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, boolean sendMail) {
        HashMap<String, Object> copyOfParams = new HashMap<String, Object>();
        IssueEventDispatcher.putBaseUrlIntoPlay(copyOfParams);
        IssueEventDispatcher.dispatchEvent(eventTypeId, issue, remoteUser, comment, worklog, changelog, copyOfParams, sendMail);
    }

    public static void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params) {
        Map<String, Object> copyOfParams = IssueEventDispatcher.copyParams(params);
        IssueEventDispatcher.putBaseUrlIntoPlay(copyOfParams);
        IssueEventDispatcher.dispatchEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, copyOfParams, eventTypeId, true, false, IssueEventDispatcher.getSpanningOperation()));
    }

    public static void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail) {
        Map<String, Object> copyOfParams = IssueEventDispatcher.copyParams(params);
        IssueEventDispatcher.putBaseUrlIntoPlay(copyOfParams);
        IssueEventDispatcher.dispatchEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, copyOfParams, eventTypeId, sendMail, false, IssueEventDispatcher.getSpanningOperation()));
    }

    public static void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, GenericValue changelog, boolean sendMail, boolean subtasksUpdated) {
        IssueEventDispatcher.dispatchEvent(eventTypeId, issue, remoteUser, null, null, changelog, null, sendMail, subtasksUpdated);
    }

    public static void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail, boolean subtasksUpdated) {
        Map<String, Object> copyOfParams = IssueEventDispatcher.copyParams(params);
        IssueEventDispatcher.putBaseUrlIntoPlay(copyOfParams);
        IssueEventDispatcher.dispatchEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, copyOfParams, eventTypeId, sendMail, subtasksUpdated, IssueEventDispatcher.getSpanningOperation()));
    }

    private static Map<String, Object> copyParams(Map params) {
        HashMap<String, Object> copyOfParams = new HashMap<String, Object>();
        if (params != null) {
            copyOfParams.putAll(params);
        }
        return copyOfParams;
    }

    private static void putBaseUrlIntoPlay(Map<String, Object> params) {
        params.put("baseurl", ComponentAccessor.getApplicationProperties().getString("jira.baseurl"));
    }

    public static void dispatchEvent(IssueEvent event) {
        if (ImportUtils.isEnableNotifications()) {
            ((EventPublisher)ComponentAccessor.getComponentOfType(EventPublisher.class)).publish((Object)event);
            ((TxnAwareEventFactory)ComponentAccessor.getComponent(TxnAwareEventFactory.class)).publishOnCommitEvent(() -> OnCommitIssueEventBuilder.builder(event).setOnCommitEventDataReloadStatus(OnCommitEvent.OnCommitEventDataReloadStatus.NOT_RELOADED_ON_COMMIT).build());
        }
    }

    private static SpanningOperation getSpanningOperation() {
        return ((SpanningOperationHolder)ComponentAccessor.getComponent(SpanningOperationHolder.class)).get();
    }
}

