/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue.txnaware;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.commit.OnCommitEvent;
import com.atlassian.jira.event.issue.DelegatingJiraIssueEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueChangedEventImpl;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEventBuilder;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEventBundle;
import com.atlassian.jira.event.issue.commit.OnCommitJiraIssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitJiraIssueEventBuilder;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import com.atlassian.jira.event.operation.SpanningOperationHolder;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.transaction.RequestLocalTransactionRunnableQueueFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class TxnAwareEventFactoryImpl
implements TxnAwareEventFactory {
    private final EventPublisher eventPublisher;
    private final RequestLocalTransactionRunnableQueueFactory runnableQueueFactory;
    private final ComponentLocator componentLocator;
    private final SpanningOperationHolder spanningOperationHolder;

    public TxnAwareEventFactoryImpl(EventPublisher eventPublisher, RequestLocalTransactionRunnableQueueFactory runnableQueueFactory, ComponentLocator componentLocator, SpanningOperationHolder spanningOperationHolder) {
        this.eventPublisher = eventPublisher;
        this.runnableQueueFactory = runnableQueueFactory;
        this.componentLocator = componentLocator;
        this.spanningOperationHolder = spanningOperationHolder;
    }

    @Override
    public void issueChangedEventOnCommit(long issueId, ApplicationUser author, Comment comment, long changeGroupId, boolean sendMail) {
        this.runThisOnCommit(transactionStatusUnused -> {
            Optional<ChangeHistory> changeHistory = this.getChangeHistory(changeGroupId);
            changeHistory.ifPresent(history -> {
                List changeItems = history.getChangeItemBeans();
                if (changeItems != null && !changeItems.isEmpty()) {
                    IssueChangedEvent issueChangeEvent = this.makeChangedEvent(issueId, author, comment, changeItems, history.getTimePerformed(), sendMail);
                    this.publishEvent(issueChangeEvent);
                }
            });
        });
    }

    @Override
    public void publishOnCommitIssueEventBundle(Supplier<OnCommitIssueEventBundle> onCommitBundleEventSupplier) {
        this.runThisOnCommit(transactionStatus -> {
            OnCommitIssueEventBundle onCommitIssueEventBundle = (OnCommitIssueEventBundle)onCommitBundleEventSupplier.get();
            if (onCommitIssueEventBundle == null) {
                return;
            }
            List nonRedundantEvents = (List)onCommitIssueEventBundle.getOnCommitEvents().stream().filter(this::isNotNullOrRedundantEvent).map(onCommitEvent -> this.makeOnCommitEventToPublish((OnCommitEvent)onCommitEvent, (OnCommitEvent.OnCommitEventTransactionStatus)transactionStatus)).collect(CollectorsUtil.toImmutableList());
            if (nonRedundantEvents.isEmpty()) {
                return;
            }
            nonRedundantEvents.forEach(this::publishEvent);
            this.publishEvent(() -> nonRedundantEvents);
        });
    }

    @Override
    public void publishOnCommitEvent(Supplier<OnCommitEvent> onCommitEventSupplier) {
        this.runThisOnCommit(transactionStatus -> {
            OnCommitEvent onCommitEvent = (OnCommitEvent)onCommitEventSupplier.get();
            if (this.isNullOrRedundantEvent(onCommitEvent)) {
                return;
            }
            this.publishEvent(this.makeOnCommitEventToPublish(onCommitEvent, (OnCommitEvent.OnCommitEventTransactionStatus)transactionStatus));
        });
    }

    private Optional<ChangeHistory> getChangeHistory(long changeGroupId) {
        ChangeHistory changeHistory = ((ChangeHistoryManager)this.componentLocator.getComponent(ChangeHistoryManager.class)).getChangeHistoryById(Long.valueOf(changeGroupId));
        return Optional.ofNullable(changeHistory);
    }

    private IssueChangedEvent makeChangedEvent(long issueId, ApplicationUser author, Comment comment, List<ChangeItemBean> changeItems, Timestamp timePerformed, boolean sendMail) {
        Issue issue = this.getIssueObject(issueId);
        Date eventTime = new Date(timePerformed.getTime());
        return new IssueChangedEventImpl(issue, Optional.ofNullable(author), changeItems, Optional.ofNullable(comment), eventTime, sendMail, this.spanningOperationHolder.get());
    }

    private OnCommitEvent makeOnCommitEventToPublish(OnCommitEvent onCommitEvent, OnCommitEvent.OnCommitEventTransactionStatus transactionStatus) {
        OnCommitIssueEvent onCommitEventToPublish;
        if (onCommitEvent instanceof OnCommitIssueEvent) {
            onCommitEventToPublish = OnCommitIssueEventBuilder.builder((OnCommitIssueEvent)onCommitEvent).setOnCommitEventTransactionStatus(transactionStatus).build();
        } else if (onCommitEvent instanceof OnCommitJiraIssueEvent) {
            onCommitEventToPublish = OnCommitJiraIssueEventBuilder.builder((OnCommitJiraIssueEvent)onCommitEvent).setOnCommitEventTransactionStatus(transactionStatus).build();
        } else if (onCommitEvent instanceof OnCommitEvent.OnCommitEventTransactionStatusSettable) {
            ((OnCommitEvent.OnCommitEventTransactionStatusSettable)onCommitEvent).setOnCommitEventTransactionStatus(transactionStatus);
            onCommitEventToPublish = onCommitEvent;
        } else {
            onCommitEventToPublish = onCommitEvent;
        }
        return onCommitEventToPublish;
    }

    private Issue getIssueObject(long issueId) {
        IssueManager issueManager = (IssueManager)this.componentLocator.getComponent(IssueManager.class);
        return issueManager.getIssueObject(Long.valueOf(issueId));
    }

    @VisibleForTesting
    boolean isNullOrRedundantEvent(OnCommitEvent onCommitEvent) {
        return Optional.ofNullable(onCommitEvent).map(OnCommitEvent::getWrappedEvent).map(wrappedEvent -> {
            if (wrappedEvent instanceof IssueEvent) {
                return ((IssueEvent)wrappedEvent).isRedundant();
            }
            if (wrappedEvent instanceof DelegatingJiraIssueEvent) {
                return Optional.ofNullable(((DelegatingJiraIssueEvent)wrappedEvent).asIssueEvent()).map(IssueEvent::isRedundant).orElse(true);
            }
            return false;
        }).orElse(true);
    }

    private boolean isNotNullOrRedundantEvent(OnCommitEvent onCommitEvent) {
        return !this.isNullOrRedundantEvent(onCommitEvent);
    }

    private void runThisOnCommit(Consumer<OnCommitEvent.OnCommitEventTransactionStatus> onCommitFunction) {
        if (this.isInTransaction()) {
            this.runnableQueueFactory.getRunnablesQueue().offer(() -> onCommitFunction.accept(OnCommitEvent.OnCommitEventTransactionStatus.TRANSACTION));
        } else {
            SafePluginPointAccess.to().runnable(() -> onCommitFunction.accept(OnCommitEvent.OnCommitEventTransactionStatus.NO_TRANSACTION));
        }
    }

    @VisibleForTesting
    boolean isInTransaction() {
        return CoreTransactionUtil.inTransaction();
    }

    private void publishEvent(IssueChangedEvent event) {
        this.eventPublisher.publish((Object)event);
    }

    private void publishEvent(OnCommitEvent onCommitEvent) {
        this.eventPublisher.publish((Object)onCommitEvent);
    }

    private void publishEvent(OnCommitIssueEventBundle onCommitIssueEventBundle) {
        this.eventPublisher.publish((Object)onCommitIssueEventBundle);
    }
}

