/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.atlassian.jira.health.ModificationMigrationLocationService;
import com.atlassian.modzdetector.HashAlgorithm;
import com.atlassian.modzdetector.MD5HashAlgorithm;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModificationsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModificationsManager.class);
    private final ModificationMigrationLocationService locationService;
    private final HashAlgorithm hashAlgorithm;

    public static ModificationsManager getInstance() {
        return new ModificationsManager(ModificationMigrationLocationService.getInstance(), (HashAlgorithm)new MD5HashAlgorithm());
    }

    public ModificationsManager(ModificationMigrationLocationService locationService) {
        this(locationService, (HashAlgorithm)new MD5HashAlgorithm());
    }

    @VisibleForTesting
    public ModificationsManager(ModificationMigrationLocationService locationService, HashAlgorithm hashAlgorithm) {
        this.locationService = Objects.requireNonNull(locationService);
        this.hashAlgorithm = Objects.requireNonNull(hashAlgorithm);
    }

    @Nonnull
    public Set<Path> getSavedModificationsFromModificationsFolder() {
        try {
            Path customisations = this.locationService.getCustomisationsDirectory();
            if (!customisations.toFile().exists() || !customisations.toFile().isDirectory()) {
                return Collections.emptySet();
            }
            return FileUtils.listFiles((File)customisations.toFile(), null, (boolean)true).stream().filter(f -> !f.isDirectory()).map(f -> customisations.relativize(f.toPath())).filter(f -> this.isDifferent(this.locationService.getCustomisationsDirectory(), (Path)f)).collect(Collectors.toSet());
        }
        catch (IllegalStateException e) {
            LOGGER.warn("No Jira home found");
            return Collections.emptySet();
        }
    }

    private boolean isDifferent(Path customisationsDirectory, Path customisedFilePath) {
        try {
            Path absoluteCustomisedPath = customisationsDirectory.resolve(customisedFilePath);
            String backedUpHash = this.calculateHash(absoluteCustomisedPath);
            Path tomcatBase = this.locationService.getInstallationRootDirectory();
            Path actualFile = tomcatBase.resolve(customisedFilePath);
            if (actualFile.toFile().exists()) {
                String actualHash = this.calculateHash(actualFile);
                return !backedUpHash.equals(actualHash);
            }
            return false;
        }
        catch (IOException ioe) {
            LOGGER.error("Couldn't perform the hash comparison", (Throwable)ioe);
            return false;
        }
    }

    private String calculateHash(Path path) throws IOException {
        try (FileInputStream is = new FileInputStream(path.toFile());){
            String string = this.hashAlgorithm.getHash((InputStream)is);
            return string;
        }
    }
}

