/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.bc.dataimport.DowngradeWorker;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.database.DbConnectionManagerImpl;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.upgrade.DowngradeException;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryManager;
import com.atlassian.jira.upgrade.util.UpgradeUtils;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.ofbiz.core.entity.DelegatorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildVersionCheck
extends HealthCheckTemplate {
    private static final Logger log = LoggerFactory.getLogger(BuildVersionCheck.class);
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/qDOwMw");

    public BuildVersionCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        return new BuildVersionCheckCalculator(this, new BuildUtilsInfoImpl(), JiraSystemProperties.getInstance(), ComponentAccessor.getComponentSafely(DatabaseConfigurationManager.class), ComponentAccessor.getComponentSafely(UpgradeVersionHistoryManager.class), () -> UpgradeUtils.tableExists("project"), (databaseConfigurationManager, buildUtilsInfo, upgradeVersionHistoryManager) -> {
            DbConnectionManagerImpl dbConnectionManager = new DbConnectionManagerImpl(databaseConfigurationManager, (DelegatorInterface)CoreFactory.getGenericDelegator());
            DefaultOfBizDelegator ofBizDelegator = new DefaultOfBizDelegator((DelegatorInterface)CoreFactory.getGenericDelegator());
            ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
            return new DowngradeWorker(buildUtilsInfo, dbConnectionManager, ofBizDelegator, applicationProperties, upgradeVersionHistoryManager);
        }).check();
    }

    private static HealthCheckMessageFormatter getErrorMessage(boolean downgradeable, boolean downgrading, int databaseBuildVersionNumber, int applicationBuildVersionNumber) {
        HealthCheckMessageFormatter formatter = new HealthCheckMessageFormatter();
        formatter.append(HealthCheckMessageFormatter.string("The version of the data present in your database is higher than the version of Jira you are trying to start.")).addLineBreak();
        formatter.appendList(HealthCheckMessageFormatter.string("Database build number: ").append(HealthCheckMessageFormatter.tag("strong", HealthCheckMessageFormatter.string(Integer.toString(databaseBuildVersionNumber)))), HealthCheckMessageFormatter.string("Jira app build number: ").append(HealthCheckMessageFormatter.tag("strong", HealthCheckMessageFormatter.string(Integer.toString(applicationBuildVersionNumber)))));
        formatter.addLineBreak();
        if (downgradeable && downgrading) {
            formatter.append(HealthCheckMessageFormatter.string("You tried to downgrade your database build version with the "), HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string("-Djira.downgrade.allowed")), HealthCheckMessageFormatter.string(" flag, but the downgrade failed. Check the log file for more details."));
            formatter.addLineBreak();
        }
        if (!downgradeable && downgrading) {
            formatter.append(HealthCheckMessageFormatter.string("You tried to downgrade your database build version with the "), HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string("-Djira.downgrade.allowed")), HealthCheckMessageFormatter.string(" flag."));
            formatter.append(HealthCheckMessageFormatter.string("However the current state of your database does not allow a downgrade."));
            formatter.addLineBreak();
        }
        formatter.append(HealthCheckMessageFormatter.string("The best solution is to upgrade Jira to a version that is equal or higher than the version of your data."));
        formatter.addLineBreak();
        if (downgradeable && !downgrading) {
            formatter.append(HealthCheckMessageFormatter.string("You could also try to downgrade your current database build version to match the version of Jira you are trying to start."));
            formatter.addLineBreak();
            formatter.append(HealthCheckMessageFormatter.string("Review our documentation and try what works for you."));
            formatter.addLineBreak();
        }
        return formatter;
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.POST_DATABASE_ACTIVATED));
    }

    static class BuildVersionCheckCalculator {
        private final BuildVersionCheck check;
        private final BuildUtilsInfo buildUtilsInfo;
        private final JiraProperties jiraSystemProperties;
        private final Optional<DatabaseConfigurationManager> databaseConfigurationManagerOpt;
        private final Optional<UpgradeVersionHistoryManager> upgradeVersionHistoryManagerOpt;
        private final Supplier<Boolean> isDatabaseSetup;
        private final DowngradeWorkerFactory downgradeWorkerFactory;

        BuildVersionCheckCalculator(BuildVersionCheck check, BuildUtilsInfo buildUtilsInfo, JiraProperties jiraSystemProperties, Optional<DatabaseConfigurationManager> databaseConfigurationManagerOpt, Optional<UpgradeVersionHistoryManager> upgradeVersionHistoryManagerOpt, Supplier<Boolean> isDatabaseSetup, DowngradeWorkerFactory downgradeWorkerFactory) {
            this.check = check;
            this.buildUtilsInfo = buildUtilsInfo;
            this.jiraSystemProperties = jiraSystemProperties;
            this.databaseConfigurationManagerOpt = databaseConfigurationManagerOpt;
            this.upgradeVersionHistoryManagerOpt = upgradeVersionHistoryManagerOpt;
            this.isDatabaseSetup = isDatabaseSetup;
            this.downgradeWorkerFactory = downgradeWorkerFactory;
        }

        List<HealthCheckResult> check() {
            if (this.isDatabaseSetup.get().booleanValue()) {
                final int applicationBuildVersionNumber = this.buildUtilsInfo.getApplicationBuildNumber();
                final int databaseBuildVersionNumber = this.buildUtilsInfo.getDatabaseBuildNumber();
                if (!this.databaseConfigurationManagerOpt.isPresent()) {
                    String message = "Could not execute health check, DatabaseConfigurationManager not available.";
                    return HealthCheckResult.fail(this.check, new Event(JohnsonEventType.DATABASE.eventType(), "Could not execute health check, DatabaseConfigurationManager not available.", JohnsonEventLevel.FATAL.eventLevel()), KB_URL, "DatabaseConfigurationManager", "Could not execute health check, DatabaseConfigurationManager not available.");
                }
                final DatabaseConfigurationManager databaseConfigurationManager = this.databaseConfigurationManagerOpt.get();
                return new Supplier<List<HealthCheckResult>>(){

                    @Override
                    public List<HealthCheckResult> get() {
                        if (databaseBuildVersionNumber > applicationBuildVersionNumber) {
                            if (jiraSystemProperties.getBoolean("jira.downgrade.allowed").booleanValue()) {
                                if (!upgradeVersionHistoryManagerOpt.isPresent()) {
                                    return this.getHealthCheckResult("Couldn't downgrade because UpgradeVersionHistoryManager is not available", "Couldn't downgrade because UpgradeVersionHistoryManager is not available", JohnsonEventLevel.FATAL.eventLevel(), KB_URL, "UpgradeVersionHistoryManager");
                                }
                                return this.attemptDowngrade((UpgradeVersionHistoryManager)upgradeVersionHistoryManagerOpt.get());
                            }
                            boolean canAttemptDowngrade = this.canAttemptDowngrade(upgradeVersionHistoryManagerOpt);
                            HealthCheckMessageFormatter message = BuildVersionCheck.getErrorMessage(canAttemptDowngrade, false, databaseBuildVersionNumber, applicationBuildVersionNumber);
                            return this.getHealthCheckResult(message.toHtml(), message.toText(), JohnsonEventLevel.FATAL.eventLevel(), KB_URL, "inconsistent-build-number");
                        }
                        if (jiraSystemProperties.getBoolean("jira.downgrade.allowed").booleanValue()) {
                            String message = "System property jira.downgrade.allowed is set to 'true' but no downgrade is required. It is recommended to remove this setting unless you actually need to downgrade.";
                            log.warn("System property jira.downgrade.allowed is set to 'true' but no downgrade is required. It is recommended to remove this setting unless you actually need to downgrade.");
                            return Collections.emptyList();
                        }
                        return Collections.emptyList();
                    }

                    private List<HealthCheckResult> getHealthCheckResult(String message, String logMessage, EventLevel level, URL kbURL, String cause) {
                        Event johnsonEvent = new Event(JohnsonEventType.DATABASE.eventType(), "Failed to start Jira due to a build number inconsistency.", message, level);
                        return HealthCheckResult.fail(check, johnsonEvent, kbURL, cause, logMessage);
                    }

                    private boolean canAttemptDowngrade(Optional<UpgradeVersionHistoryManager> upgradeVersionHistoryManagerOpt) {
                        try {
                            return upgradeVersionHistoryManagerOpt.isPresent() && this.buildDowngradeWorker(upgradeVersionHistoryManagerOpt.get()).canDowngrade();
                        }
                        catch (DowngradeException ex) {
                            log.error("Unexpected error in the Downgrade Task framework.", (Throwable)ex);
                            return false;
                        }
                    }

                    private DowngradeWorker buildDowngradeWorker(UpgradeVersionHistoryManager upgradeVersionHistoryManager) {
                        return downgradeWorkerFactory.createDowngradeWorker(databaseConfigurationManager, buildUtilsInfo, upgradeVersionHistoryManager);
                    }

                    private List<HealthCheckResult> attemptDowngrade(UpgradeVersionHistoryManager upgradeVersionHistoryManager) {
                        DowngradeWorker downgradeWorker = this.buildDowngradeWorker(upgradeVersionHistoryManager);
                        try {
                            downgradeWorker.downgrade(DowngradeWorker.Mode.START_UP);
                            downgradeWorker.writeNewBuildNumbers();
                            return Collections.emptyList();
                        }
                        catch (Exception e) {
                            log.error("Error downgrading.", (Throwable)e);
                            HealthCheckMessageFormatter errorMessage = BuildVersionCheck.getErrorMessage(this.canAttemptDowngrade(upgradeVersionHistoryManagerOpt), true, databaseBuildVersionNumber, applicationBuildVersionNumber);
                            return this.getHealthCheckResult(errorMessage.toHtml(), errorMessage.toText(), JohnsonEventLevel.FATAL.eventLevel(), KB_URL, "downgrade-error");
                        }
                    }
                }.get();
            }
            return Collections.emptyList();
        }

        static interface DowngradeWorkerFactory {
            public DowngradeWorker createDowngradeWorker(DatabaseConfigurationManager var1, BuildUtilsInfo var2, UpgradeVersionHistoryManager var3);
        }
    }
}

