/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.health.checks.database.SupportedDatabases;
import com.atlassian.jira.health.checks.database.strategy.AzureVersionPrefixStrategy;
import com.atlassian.jira.health.checks.database.strategy.EmptyVersionPrefixStrategy;
import com.atlassian.jira.health.checks.database.strategy.VersionPrefixStrategy;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SupportedDatabaseVersionHealthCheck
extends HealthCheckTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupportedDatabaseVersionHealthCheck.class);
    private static final String CAUSE = "supported-database-version-check";
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/gqr1Nw");
    private static final EnumSet databaseVendorsThisHealthCheckHasBeenTestedWith = EnumSet.of(DatabaseVendor.MY_SQL, DatabaseVendor.POSTGRES, DatabaseVendor.SQL_SERVER, DatabaseVendor.ORACLE);

    public SupportedDatabaseVersionHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    private boolean isSupported(@Nonnull DatabaseVendor vendor, @Nullable String databaseVersion) {
        if (databaseVersion == null) {
            return false;
        }
        List<String> versionList = SupportedDatabases.getDatabaseVersions().get(vendor);
        try {
            return versionList.contains(vendor.getVersion(databaseVersion));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("SupportedDatabaseVersionHealthCheck is unable to run because: {}. This probably means the database is not supported", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return Collections.singleton(LifecyclePhase.POST_DATABASE_ACTIVATED);
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        DatabaseAccessor databaseAccessor = (DatabaseAccessor)ComponentAccessor.getComponent(DatabaseAccessor.class);
        return this.getHealthCheckResults(databaseAccessor);
    }

    private List<HealthCheckResult> getHealthCheckResults(DatabaseAccessor databaseAccessor) {
        String databaseVersion;
        DatabaseVendor vendor = databaseAccessor.getDatabaseVendor();
        if (databaseVendorsThisHealthCheckHasBeenTestedWith.contains(vendor) && !this.isSupported(vendor, databaseVersion = this.getVersionPrefixStrategy(vendor).prefix(databaseAccessor.getVersion()))) {
            HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string(vendor.getHumanReadableName())).append(HealthCheckMessageFormatter.string(" ")).append(HealthCheckMessageFormatter.string(vendor.getHumanReadableVersion(databaseVersion))).append(HealthCheckMessageFormatter.string(" is not supported. You should migrate to a supported database version.")).addLineBreak().append(HealthCheckMessageFormatter.string("Supported versions are: ")).append(HealthCheckMessageFormatter.string(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)SupportedDatabases.getDatabaseVersions().get(vendor))));
            Event event = new Event(JohnsonEventType.DATABASE.eventType(), "Supported database", messageFormatter.toHtml(), EventLevels.warning());
            event.addAttribute((Object)"dismissible", (Object)true);
            return HealthCheckResult.fail(this, event, KB_URL, CAUSE, messageFormatter.toText());
        }
        return Collections.emptyList();
    }

    private VersionPrefixStrategy getVersionPrefixStrategy(DatabaseVendor vendor) {
        if (vendor == DatabaseVendor.SQL_SERVER) {
            return new AzureVersionPrefixStrategy((DatabaseAccessor)ComponentAccessor.getComponent(DatabaseAccessor.class));
        }
        return EmptyVersionPrefixStrategy.INSTANCE;
    }
}

