/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.help.HelpUrlsApplicationKeyProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class DefaultHelpUrlsApplicationKeyProvider
implements HelpUrlsApplicationKeyProvider {
    private final JiraAuthenticationContext ctx;
    private final ApplicationRoleManager applicationRoleManager;

    public DefaultHelpUrlsApplicationKeyProvider(JiraAuthenticationContext ctx, ApplicationRoleManager applicationRoleManager) {
        this.ctx = ctx;
        this.applicationRoleManager = applicationRoleManager;
    }

    @Override
    @Nonnull
    public ApplicationKey getApplicationKeyForUser() {
        return this.selectApplicationKeyForHelp(this.getApplicationKeysForUser());
    }

    private Stream<ApplicationKey> getApplicationKeysForUser() {
        ApplicationUser loggedInUser = this.ctx.getLoggedInUser();
        if (loggedInUser != null) {
            return this.applicationRoleManager.getRolesForUser(loggedInUser).stream().filter(ApplicationRole::isDefined).map(ApplicationRole::getKey);
        }
        return Stream.empty();
    }

    private ApplicationKey selectApplicationKeyForHelp(Stream<ApplicationKey> availableApplications) {
        ImmutableList applicationsOtherThanCore = (ImmutableList)availableApplications.filter(e -> !ApplicationKeys.CORE.equals(e)).limit(2L).collect(CollectorsUtil.toImmutableListWithCapacity((int)2));
        return applicationsOtherThanCore.size() == 1 ? (ApplicationKey)applicationsOtherThanCore.get(0) : ApplicationKeys.CORE;
    }
}

