/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.i18n.terminology.ArticleAdjuster;
import com.atlassian.jira.i18n.terminology.TerminologyCapitalisationFormatter;
import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import com.atlassian.jira.i18n.terminology.TerminologyEntryReader;
import com.atlassian.jira.i18n.terminology.TerminologyTransformer;
import com.atlassian.jira.i18n.terminology.ValidatedTerminologyEntryImpl;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;

@ReturnValuesAreNonnullByDefault
@ParametersAreNonnullByDefault
@ThreadSafe
public class TerminologyTransformerImpl
implements TerminologyTransformer,
Startable {
    private volatile ImmutableList<TokenHandler> tokenHandlers;
    private final TerminologyEntryReader terminologyEntryReader;

    public TerminologyTransformerImpl(TerminologyEntryReader terminologyEntryReader) {
        this.terminologyEntryReader = terminologyEntryReader;
        this.tokenHandlers = ImmutableList.of();
    }

    public void start() {
        this.refreshTerminologyEntries();
    }

    @Override
    public void refreshTerminologyEntries() {
        TokenHandlerFactory tokenHandlerFactory = new TokenHandlerFactory(this.terminologyEntryReader.getAllTerminologyEntries());
        this.tokenHandlers = (ImmutableList)Arrays.stream(ValidatedTerminologyEntryImpl.AllowedOriginalName.values()).map(tokenHandlerFactory::create).collect(ImmutableList.toImmutableList());
    }

    @Override
    public String process(String text) {
        ImmutableList<TokenHandler> currentTokenHandlers = this.tokenHandlers;
        String result = text;
        for (TokenHandler tokenHandler : currentTokenHandlers) {
            result = tokenHandler.replaceTokens(result);
        }
        return result;
    }

    @Immutable
    private static class TokenRemover
    extends TokenHandler {
        TokenRemover(String name, String namePlural) {
            String identityReplacement = "$1";
            this.singularPattern = Pattern.compile("%(" + name + ")" + "%", 2);
            this.pluralPattern = Pattern.compile("%(" + namePlural + ")" + "%", 2);
            this.singularReplacement = "$1";
            this.pluralReplacement = "$1";
        }

        @Override
        String replaceTokens(String text) {
            String pluralReplaced = this.pluralPattern.matcher(text).replaceAll(this.pluralReplacement);
            return this.singularPattern.matcher(pluralReplaced).replaceAll(this.singularReplacement);
        }
    }

    @Immutable
    private static class TokenReplacer
    extends TokenHandler {
        private static final String ARTICLE_REGEX = "(?:(?:^|\\W)(an?))?(?:\\W|<[^>]+>)*";
        private final TerminologyCapitalisationFormatter capitalisationFormatter;
        private final ArticleAdjuster articleAdjuster;

        TokenReplacer(TerminologyEntry terminologyEntry, TerminologyCapitalisationFormatter capitalisationFormatter, ArticleAdjuster articleAdjuster) {
            this.capitalisationFormatter = capitalisationFormatter;
            this.articleAdjuster = articleAdjuster;
            this.singularPattern = Pattern.compile("(?:(?:^|\\W)(an?))?(?:\\W|<[^>]+>)*%(" + terminologyEntry.getOriginalName() + ")" + "%", 2);
            this.pluralPattern = Pattern.compile("(?:(?:^|\\W)(an?))?(?:\\W|<[^>]+>)*%(" + terminologyEntry.getOriginalNamePlural() + ")" + "%", 2);
            this.singularReplacement = terminologyEntry.getNewName();
            this.pluralReplacement = terminologyEntry.getNewNamePlural();
        }

        @Override
        String replaceTokens(String text) {
            String pluralReplaced = this.replaceTokens(this.pluralPattern, this.pluralReplacement, text);
            return this.replaceTokens(this.singularPattern, this.singularReplacement, pluralReplaced);
        }

        String replaceTokens(Pattern pattern, String replacement, String text) {
            Matcher matcher = pattern.matcher(text);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String articleToReplace = matcher.group(1);
                String wordToReplace = matcher.group(2);
                String capitalizedReplacement = this.getCapitalizedReplacement(replacement, wordToReplace);
                String capitalized = this.applyCapitalization(matcher.group(0), "%" + wordToReplace + "%", capitalizedReplacement);
                String adjustedAndCapitalized = this.adjustArticle(capitalized, articleToReplace, capitalizedReplacement);
                matcher.appendReplacement(result, adjustedAndCapitalized);
            }
            matcher.appendTail(result);
            return result.toString();
        }

        private String adjustArticle(String match, String articleToReplace, String capitalizedReplacement) {
            if (StringUtils.isNotBlank((CharSequence)articleToReplace)) {
                String newArticle = this.articleAdjuster.getArticle(articleToReplace, capitalizedReplacement);
                return match.replaceFirst(Pattern.quote(articleToReplace), newArticle);
            }
            return match;
        }

        private String applyCapitalization(String sentence, String wordToReplace, String capitalizedReplacement) {
            return sentence.replaceFirst(Pattern.quote(wordToReplace), capitalizedReplacement);
        }

        private String getCapitalizedReplacement(String textToFormat, String originalText) {
            return this.capitalisationFormatter.applyFormatting(textToFormat, originalText);
        }
    }

    @Immutable
    private static abstract class TokenHandler {
        protected static final String TOKEN = "%";
        protected Pattern singularPattern;
        protected Pattern pluralPattern;
        protected String singularReplacement;
        protected String pluralReplacement;

        private TokenHandler() {
        }

        abstract String replaceTokens(String var1);
    }

    private static class TokenHandlerFactory {
        final Map<String, TerminologyEntry> entriesWithNonOriginalNames;

        TokenHandlerFactory(Collection<TerminologyEntry> terminologyEntries) {
            this.entriesWithNonOriginalNames = terminologyEntries.stream().filter(TerminologyEntry::hasNonOriginalNames).collect(Collectors.toMap(TerminologyEntry::getOriginalName, entry -> entry));
        }

        public TokenHandler create(ValidatedTerminologyEntryImpl.AllowedOriginalName originalName) {
            TerminologyEntry entryToAdd = this.entriesWithNonOriginalNames.get(originalName.getSingular());
            return entryToAdd == null ? new TokenRemover(originalName.getSingular(), originalName.getPlural()) : new TokenReplacer(entryToAdd, new TerminologyCapitalisationFormatter(), new ArticleAdjuster());
        }
    }
}

