/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalProjectRoleActor;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectRoleActorMapper;
import com.atlassian.jira.imports.project.parser.ProjectRoleActorParser;
import com.atlassian.jira.imports.project.parser.ProjectRoleActorParserImpl;
import java.util.Map;

public class ProjectRoleActorMapperHandler
implements ImportOfBizEntityHandler {
    private final BackupProject backupProject;
    private final ProjectRoleActorMapper projectRoleActorMapper;
    private ProjectRoleActorParser projectRoleActorParser;

    public ProjectRoleActorMapperHandler(BackupProject backupProject, ProjectRoleActorMapper projectRoleActorMapper) {
        this.backupProject = backupProject;
        this.projectRoleActorMapper = projectRoleActorMapper;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if ("ProjectRoleActor".equals(entityName)) {
            ExternalProjectRoleActor externalProjectRoleActor = this.getProjectRoleActorParser().parse(attributes);
            if (this.backupProject.getProject().getId().equals(externalProjectRoleActor.getProjectId())) {
                this.projectRoleActorMapper.flagValueActorAsInUse(externalProjectRoleActor);
            }
        }
    }

    ProjectRoleActorParser getProjectRoleActorParser() {
        if (this.projectRoleActorParser == null) {
            this.projectRoleActorParser = new ProjectRoleActorParserImpl();
        }
        return this.projectRoleActorParser;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectRoleActorMapperHandler that = (ProjectRoleActorMapperHandler)o;
        if (this.backupProject != null ? !this.backupProject.equals(that.backupProject) : that.backupProject != null) {
            return false;
        }
        if (this.projectRoleActorMapper != null ? !this.projectRoleActorMapper.equals(that.projectRoleActorMapper) : that.projectRoleActorMapper != null) {
            return false;
        }
        return !(this.projectRoleActorParser != null ? !this.projectRoleActorParser.equals(that.projectRoleActorParser) : that.projectRoleActorParser != null);
    }

    public int hashCode() {
        int result = this.backupProject != null ? this.backupProject.hashCode() : 0;
        result = 31 * result + (this.projectRoleActorMapper != null ? this.projectRoleActorMapper.hashCode() : 0);
        result = 31 * result + (this.projectRoleActorParser != null ? this.projectRoleActorParser.hashCode() : 0);
        return result;
    }
}

