/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalIssue;
import com.atlassian.jira.external.beans.ExternalIssueImpl;
import com.atlassian.jira.imports.project.parser.IssueParser;
import com.atlassian.jira.util.dbc.Null;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IssueParserImpl
implements IssueParser {
    @Override
    public ExternalIssue parse(Map attributes) throws ParseException {
        Null.not("The 'attributes' parameter cannot be null.", attributes);
        String idStr = (String)attributes.get("id");
        String summary = (String)attributes.get("summary");
        String key = (String)attributes.get("key");
        String project = (String)attributes.get("project");
        String type = (String)attributes.get("type");
        String status = (String)attributes.get("status");
        String resolution = (String)attributes.get("resolution");
        String reporter = (String)attributes.get("reporter");
        String assignee = (String)attributes.get("assignee");
        String creator = (String)attributes.get("creator");
        String description = (String)attributes.get("description");
        String environment = (String)attributes.get("environment");
        String priority = (String)attributes.get("priority");
        String created = (String)attributes.get("created");
        String updated = (String)attributes.get("updated");
        String duedate = (String)attributes.get("duedate");
        String resolutionDate = (String)attributes.get("resolutiondate");
        String votesStr = (String)attributes.get("votes");
        String watchesStr = (String)attributes.get("watches");
        String timespentStr = (String)attributes.get("timespent");
        String timeoriginalestimate = (String)attributes.get("timeoriginalestimate");
        String timeestimate = (String)attributes.get("timeestimate");
        String securityLevel = (String)attributes.get("security");
        Long id = null;
        Long votes = null;
        Long watches = null;
        Long timeSpent = null;
        Long originalEstimate = null;
        Long estimate = null;
        if (StringUtils.isEmpty((CharSequence)idStr)) {
            throw new ParseException("No 'id' field for Issue.");
        }
        try {
            id = new Long(idStr);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Unable to parse the Issue id '" + idStr + "' into a long.");
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new ParseException("No 'key' field for Issue " + id + ".");
        }
        if (StringUtils.isEmpty((CharSequence)project)) {
            throw new ParseException("No 'project' field for Issue " + id + ".");
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new ParseException("No 'type' field for Issue " + id + ".");
        }
        if (StringUtils.isEmpty((CharSequence)status)) {
            throw new ParseException("No 'status' field for Issue " + id + ".");
        }
        if (votesStr != null) {
            try {
                votes = new Long(votesStr);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Unable to parse the Vote count '" + votesStr + "' for Issue '" + idStr + "'");
            }
        }
        if (watchesStr != null) {
            try {
                watches = new Long(watchesStr);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Unable to parse the Watches count '" + watchesStr + "' for Issue '" + idStr + "'");
            }
        }
        if (timespentStr != null) {
            try {
                timeSpent = new Long(timespentStr);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Unable to parse the TimeSpent '" + timespentStr + "' for Issue '" + idStr + "'");
            }
        }
        if (timeoriginalestimate != null) {
            try {
                originalEstimate = new Long(timeoriginalestimate);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Unable to parse the OriginalEstimate '" + timeoriginalestimate + "' for Issue '" + idStr + "'");
            }
        }
        if (timeestimate != null) {
            try {
                estimate = new Long(timeestimate);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Unable to parse the Time Estimate '" + timeestimate + "' for Issue '" + idStr + "'");
            }
        }
        ExternalIssueImpl issue = new ExternalIssueImpl(creator);
        issue.setId(idStr);
        issue.setKey(key);
        issue.setSummary(summary);
        issue.setProject(project);
        issue.setIssueType(type);
        issue.setStatus(status);
        issue.setResolution(resolution);
        issue.setReporter(reporter);
        issue.setAssignee(assignee);
        issue.setDescription(description);
        issue.setEnvironment(environment);
        issue.setPriority(priority);
        if (created != null) {
            issue.setCreated((Date)Timestamp.valueOf(created));
        }
        if (updated != null) {
            issue.setUpdated((Date)Timestamp.valueOf(updated));
        }
        if (duedate != null) {
            issue.setDuedate((Date)Timestamp.valueOf(duedate));
        }
        if (resolutionDate != null) {
            issue.setResolutionDate((Date)Timestamp.valueOf(resolutionDate));
        }
        issue.setVotes(votes);
        issue.setWatches(watches);
        issue.setTimeSpent(timeSpent);
        issue.setOriginalEstimate(originalEstimate);
        issue.setEstimate(estimate);
        issue.setSecurityLevel(securityLevel);
        return issue;
    }
}

