/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.transformer;

import com.atlassian.jira.external.beans.ExternalChangeItem;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValueImpl;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.transformer.ChangeItemTransformer;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;

public class ChangeItemTransformerImpl
implements ChangeItemTransformer {
    private final String mappedProjectId;
    private final CustomFieldManager customFieldManager;

    public ChangeItemTransformerImpl(String mappedProjectId, CustomFieldManager customFieldManager) {
        this.mappedProjectId = mappedProjectId;
        this.customFieldManager = customFieldManager;
    }

    @Override
    public ExternalChangeItem transform(ProjectImportMapper projectImportMapper, ExternalChangeItem changeItem) {
        CustomField importableCustomField;
        String newChangeGroupId = projectImportMapper.getChangeGroupMapper().getMappedId(changeItem.getChangeGroupId());
        String mappedOldValue = null;
        String mappedNewValue = null;
        if (newChangeGroupId != null && changeItem.getFieldType().equals("jira") && changeItem.getField().equals("status")) {
            mappedOldValue = projectImportMapper.getStatusMapper().getMappedId(changeItem.getOldValue());
            mappedNewValue = projectImportMapper.getStatusMapper().getMappedId(changeItem.getNewValue());
        }
        if (newChangeGroupId != null && changeItem.getFieldType().equals("custom") && (importableCustomField = this.getImportableCustomFieldByName(changeItem.getField())) != null) {
            ProjectCustomFieldImporter customFieldImporter = ((ProjectImportableCustomField)importableCustomField.getCustomFieldType()).getProjectImporter();
            String mappedIssueId = null;
            FieldConfig relevantConfig = importableCustomField.getRelevantConfig((IssueContext)new IssueContextImpl(Long.valueOf(this.mappedProjectId), mappedIssueId));
            ExternalCustomFieldValueImpl customFieldValue = new ExternalCustomFieldValueImpl("-1", importableCustomField.getId(), mappedIssueId);
            mappedOldValue = this.mapCustomFieldIdList(customFieldValue, changeItem.getOldValue(), customFieldImporter, projectImportMapper, relevantConfig);
            mappedNewValue = this.mapCustomFieldIdList(customFieldValue, changeItem.getNewValue(), customFieldImporter, projectImportMapper, relevantConfig);
        }
        return new ExternalChangeItem(null, newChangeGroupId, changeItem.getFieldType(), changeItem.getField(), mappedOldValue != null ? mappedOldValue : changeItem.getOldValue(), changeItem.getOldString(), mappedNewValue != null ? mappedNewValue : changeItem.getNewValue(), changeItem.getNewString());
    }

    private String mapCustomFieldIdList(ExternalCustomFieldValueImpl customFieldValue, String unmappedValueList, ProjectCustomFieldImporter customFieldImporter, ProjectImportMapper projectImportMapper, FieldConfig relevantConfig) {
        if (unmappedValueList == null) {
            return null;
        }
        StringBuffer mappedValueList = new StringBuffer();
        for (String unmappedValue : unmappedValueList.split(",")) {
            unmappedValue = unmappedValue.trim();
            customFieldValue.setStringValue(unmappedValue);
            ProjectCustomFieldImporter.MappedCustomFieldValue mappedCustomFieldOldValue = customFieldImporter.getMappedImportValue(projectImportMapper, (ExternalCustomFieldValue)customFieldValue, relevantConfig);
            String mappedValue = mappedCustomFieldOldValue.getValue();
            if (mappedValueList.length() > 0) {
                mappedValueList.append(", ");
            }
            if (mappedValue != null && mappedValue.length() > 0) {
                mappedValueList.append(mappedValue);
                continue;
            }
            mappedValueList.append(unmappedValue);
        }
        return mappedValueList.toString();
    }

    @VisibleForTesting
    CustomField getImportableCustomFieldByName(String customFieldName) {
        Collection customFields = this.customFieldManager.getCustomFieldObjectsByName(customFieldName);
        CustomField importableCustomField = null;
        for (CustomField customField : customFields) {
            if (!(customField.getCustomFieldType() instanceof ProjectImportableCustomField)) continue;
            if (importableCustomField != null) {
                return null;
            }
            importableCustomField = customField;
        }
        return importableCustomField;
    }
}

