/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.validation.ProjectAwareMapperValidator;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityMapperValidator
implements ProjectAwareMapperValidator {
    private static final Logger log = LoggerFactory.getLogger(PriorityMapperValidator.class);
    private final ProjectManager projectManager;
    private final PrioritySchemeManager prioritySchemeManager;

    public PriorityMapperValidator(ProjectManager projectManager, PrioritySchemeManager prioritySchemeManager) {
        this.projectManager = projectManager;
        this.prioritySchemeManager = prioritySchemeManager;
    }

    @Override
    public MessageSet validateMappings(I18nHelper i18nHelper, BackupProject backupProject, SimpleProjectImportIdMapper simpleProjectImportIdMapper) {
        MessageSetImpl messageSet = new MessageSetImpl();
        for (String oldPriorityId : simpleProjectImportIdMapper.getRequiredOldIds()) {
            String newPriorityId = simpleProjectImportIdMapper.getMappedId(oldPriorityId);
            if (newPriorityId == null) {
                if (simpleProjectImportIdMapper.getKey(oldPriorityId) == null) {
                    log.warn("Project Import: The priority with ID '{}' is orphan data and will be ignored.", (Object)oldPriorityId);
                    continue;
                }
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.priority.validation.does.not.exist", simpleProjectImportIdMapper.getDisplayName(oldPriorityId)));
                messageSet.addErrorMessageInEnglish("The priority '" + simpleProjectImportIdMapper.getDisplayName(oldPriorityId) + "' is required for the import but does not exist in the current JIRA instance.");
                continue;
            }
            if (this.isPriorityValidForProject(backupProject.getProject().getKey(), newPriorityId)) continue;
            String priorityDisplayName = simpleProjectImportIdMapper.getDisplayName(oldPriorityId);
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.priority.validation.not.in.scheme", priorityDisplayName));
            messageSet.addErrorMessageInEnglish("The priority '" + priorityDisplayName + "' exists in the system but is not valid for the projects priority scheme.");
        }
        return messageSet;
    }

    private boolean isPriorityValidForProject(String projectKey, String newPriorityId) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        if (project == null) {
            log.warn("Couldn't get destination project {}", (Object)projectKey);
            return false;
        }
        List prioritiesForProject = this.prioritySchemeManager.getOptions((IssueContext)new ProjectContext(project.getId()));
        return prioritiesForProject.contains(newPriorityId);
    }
}

