/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.DelayCloseable;
import com.atlassian.jira.index.DelegateSearcher;
import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.CompositeCloseable;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.lucene.search.IndexSearcher;

class DelayCloseSearcher
extends DelegateSearcher
implements DelayCloseable {
    private final DelayCloseable.Helper helper;

    DelayCloseSearcher(@Nonnull IndexSearcher searcher) {
        super((IndexSearcher)Assertions.notNull((String)"searcher", (Object)searcher));
        this.helper = new DelayCloseable.Helper(new SearcherCloser(searcher));
    }

    DelayCloseSearcher(@Nonnull IndexSearcher searcher, @Nonnull Closeable closeAction) {
        super((IndexSearcher)Assertions.notNull((String)"searcher", (Object)searcher));
        this.helper = new DelayCloseable.Helper(new CompositeCloseable(closeAction, new SearcherCloser(searcher)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DelayCloseSearcher{");
        sb.append("indexSearch.hash=@").append(Integer.toHexString(this.hashCode())).append(", ");
        sb.append("indexSearch.isClosed=").append(this.isClosed()).append(", ");
        sb.append("indexSearch.usageCount=").append(this.usageCount()).append(", ");
        sb.append("indexSearch.isCloseWhenDone=").append(this.isCloseWhenDone()).append(", ");
        sb.append("indexSearch.indexReader.hash=@").append(Integer.toHexString(this.getIndexReader().hashCode())).append(", ");
        sb.append("indexSearch.indexReader.refCount=").append(this.indexReaderRefCount()).append(", ");
        sb.append("indexSearch.indexReader.indexSearcherCount=").append(this.indexReaderRefCount() - 1);
        return sb.toString();
    }

    boolean isClosed() {
        return this.helper.isClosed();
    }

    int usageCount() {
        return this.helper.usageCount();
    }

    int indexReaderRefCount() {
        return this.getIndexReader().getRefCount();
    }

    boolean isCloseWhenDone() {
        return this.helper.isCloseWhenDone();
    }

    @Override
    public void closeWhenDone() {
        this.helper.closeWhenDone();
    }

    @Override
    public void open() {
        this.helper.open();
    }

    @Override
    public void close() {
        this.helper.close();
    }

    private static class SearcherCloser
    implements Closeable {
        private final IndexSearcher searcher;

        SearcherCloser(IndexSearcher searcher) {
            Preconditions.checkState((searcher.getIndexReader().getRefCount() >= 1 ? 1 : 0) != 0);
            this.searcher = searcher;
            searcher.getIndexReader().incRef();
        }

        @Override
        public void close() {
            try {
                this.searcher.getIndexReader().decRef();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }
}

