/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.FutureResult;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.IndexingStrategy;
import com.atlassian.jira.index.MultiThreadedIndexingConfiguration;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.index.SharedCustomFieldsVisibilityCache;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.concurrent.BoundedExecutor;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;

public class MultiThreadedIndexingStrategy
implements IndexingStrategy {
    private static final int INITIAL_CF_VISIBILITY_CACHE_CAPACITY = 2048;
    private final BoundedExecutor executor;
    private final IndexingStrategy strategy;
    private final ConcurrentHashMap<IssueContext, Set<String>> customFieldsVisibilityCache;

    public MultiThreadedIndexingStrategy(@Nonnull IndexingStrategy strategy, MultiThreadedIndexingConfiguration config, String threadPrefix) {
        this.strategy = (IndexingStrategy)Assertions.notNull((String)"strategy", (Object)strategy);
        this.executor = new BoundedExecutor(Executors.newFixedThreadPool(config.noOfThreads(), ThreadFactories.namedThreadFactory(threadPrefix)), config.maximumQueueSize());
        this.customFieldsVisibilityCache = new ConcurrentHashMap(2048);
    }

    public Index.Result apply(final Supplier<Index.Result> input) {
        return new FutureResult(this.executor.submit(new Callable<Index.Result>(){

            @Override
            public Index.Result call() throws Exception {
                try {
                    SharedCustomFieldsVisibilityCache.setThreadLocal(MultiThreadedIndexingStrategy.this.customFieldsVisibilityCache);
                    Index.Result result = (Index.Result)MultiThreadedIndexingStrategy.this.strategy.apply(input);
                    return result;
                }
                finally {
                    SharedCustomFieldsVisibilityCache.clearThreadLocal();
                }
            }
        }));
    }

    @Override
    public void close() {
        this.executor.shutdownAndWait();
    }
}

