/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.instrumentation.Counter;
import com.atlassian.jira.concurrent.Barrier;
import com.atlassian.jira.concurrent.BarrierFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.config.util.IndexWriterConfiguration;
import com.atlassian.jira.index.DefaultIndexEngine;
import com.atlassian.jira.index.PeriodicIndexWriterCommitObserver;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.google.common.base.Stopwatch;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicIndexWriterCommitScheduler {
    public static final String PERIODIC_COMMIT_BARRIER = "periodicCommit";
    private static final Logger log = LoggerFactory.getLogger(PeriodicIndexWriterCommitScheduler.class);
    private final ScheduledExecutorService executorService;
    private final Set<DefaultIndexEngine.WriterReference> writersToCommit = Collections.synchronizedSet(new HashSet());
    private final int commitFrequency;
    private final PeriodicIndexWriterCommitObserver commitObserver;
    private final Barrier writersCommitBarrier;

    public PeriodicIndexWriterCommitScheduler(PeriodicIndexWriterCommitObserver commitObserver, ApplicationProperties applicationProperties, BarrierFactory barrierFactory, EventPublisher eventPublisher) {
        this.commitObserver = commitObserver;
        int noOfThreads = PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.issue.threads", (int)10);
        this.executorService = Executors.newScheduledThreadPool(noOfThreads, new IndexEngineThreadFactory());
        int defaultCommitFrequency = (int)IndexWriterConfiguration.Default.INTERACTIVE.getCommitFrequency();
        this.commitFrequency = PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.commitfrequency", (int)defaultCommitFrequency);
        this.writersCommitBarrier = barrierFactory.getBarrier(PERIODIC_COMMIT_BARRIER);
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        this.startScheduledThread(this.commitFrequency);
    }

    @EventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        this.executorService.shutdownNow();
    }

    public void forceImmediateCommit() throws ExecutionException, InterruptedException, TimeoutException {
        this.executorService.submit(this::commitWriters, null).get(5L, TimeUnit.MINUTES);
    }

    private void startScheduledThread(int commitFrequency) {
        this.executorService.scheduleAtFixedRate(this::commitWriters, commitFrequency, commitFrequency, TimeUnit.MILLISECONDS);
    }

    public void scheduleForCommit(DefaultIndexEngine.WriterReference writer) {
        this.writersToCommit.add(writer);
    }

    protected synchronized void commitWriters() {
        log.debug("Start commitWriters, writers to commit: {}", (Object)this.writersToCommit.size());
        Stopwatch timeToCommit = Stopwatch.createStarted();
        this.writersCommitBarrier.await();
        HashSet<DefaultIndexEngine.WriterReference> committingWriters = new HashSet<DefaultIndexEngine.WriterReference>();
        try {
            this.commitObserver.onBeforeCommit();
            log.debug("PeriodicIndexWriterCommitObserver.onBeforeCommit completed");
            if (!this.writersToCommit.isEmpty()) {
                committingWriters.addAll(this.writersToCommit);
                this.writersToCommit.removeAll(committingWriters);
                log.debug("Enqueued {} writers. Starting periodic writers commit", (Object)committingWriters.size());
                CompletableFuture.allOf((CompletableFuture[])committingWriters.stream().map(writer -> CompletableFuture.runAsync(() -> this.commitWriter((DefaultIndexEngine.WriterReference)writer), this.executorService)).toArray(CompletableFuture[]::new)).join();
                log.debug("Finished commits of all the scheduled writers");
            }
            this.commitObserver.onAfterCommit();
            log.debug("PeriodicIndexWriterCommitObserver.onAfterCommit completed. Successfully finished periodic writers commit");
        }
        catch (Throwable exception) {
            log.error("Error(s) during the commit of index writers. Aborting until next scheduled attempt", exception);
            this.writersToCommit.addAll(committingWriters);
        }
        log.debug("Done commitWriters, writers to commit: {}, time to commit: {}ms", (Object)this.writersToCommit.size(), (Object)timeToCommit.stop().elapsed().toMillis());
    }

    private void commitWriter(DefaultIndexEngine.WriterReference writer) {
        try {
            writer.commit();
            this.reportSuccessfulCommit();
        }
        catch (AlreadyClosedException alreadyClosedException) {
        }
        catch (Throwable e) {
            String writerId = (String)writer.get().map(Writer::getLuceneWriter).map(IndexWriter::getDirectory).map(Directory::toString).getOrElse((Object)"Unknown");
            log.error(String.format("Error during commit of IndexWriter with following configuration: %s", writerId), e);
            throw e;
        }
    }

    private void reportSuccessfulCommit() {
        Counter luceneIndexCommitInstrument = Instrumentation.pullCounter(InstrumentationName.WRITER_LUCENE_COMMIT);
        luceneIndexCommitInstrument.incrementAndGet();
    }

    private static class IndexEngineThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadId = new AtomicLong(0L);

        private IndexEngineThreadFactory() {
        }

        @Override
        @Nonnull
        public Thread newThread(@Nonnull Runnable runnable) {
            Thread t = new Thread(JiraThreadLocalUtils.wrap(runnable), "JiraIndexCommitThread-" + this.threadId.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }
}

