/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReIndexStatsLogger {
    private static final Logger log = LoggerFactory.getLogger(ReIndexStatsLogger.class);
    private final long minLogFrequencyInSeconds = JiraStats.statsLoggingInterval(TimeUnit.SECONDS);
    private final String currentNodeId;
    private final Stopwatch lastLogTime;
    private ReIndexStats total = new ReIndexStats();
    private ReIndexStats snapshot = new ReIndexStats();

    ReIndexStatsLogger(String currentNodeId) {
        this.currentNodeId = currentNodeId;
        this.lastLogTime = Stopwatch.createStarted();
    }

    void compact(IndexDirectoryFactory.Name name, long millis, int beforeCounter, int afterCounter, int versionedCounter, int unVersionedCounter) {
        log.trace("[INDEX-REPLAY] compact raw stats: name={}, millis={}, beforeCounter={}, afterCounter={}, versionedCounter={}, unVersionedCounter={}", new Object[]{name, millis, beforeCounter, afterCounter, versionedCounter, unVersionedCounter});
        this.total.compact(name, millis, beforeCounter, afterCounter, versionedCounter, unVersionedCounter);
        this.snapshot.compact(name, millis, beforeCounter, afterCounter, versionedCounter, unVersionedCounter);
    }

    void filterOutAlreadyIndexed(IndexDirectoryFactory.Name name, long millis, int beforeCounter, int afterCounter) {
        log.trace("[INDEX-REPLAY] filterOutAlreadyIndexed raw stats: name={}, millis={}, beforeCounter={}, afterCounter={}", new Object[]{name, millis, beforeCounter, afterCounter});
        this.total.filterOutAlreadyIndexed(name, millis, beforeCounter, afterCounter);
        this.snapshot.filterOutAlreadyIndexed(name, millis, beforeCounter, afterCounter);
    }

    void updateIndex(IndexDirectoryFactory.Name name, long millis, int counter, int batchCounter) {
        log.trace("[INDEX-REPLAY] updateIndex raw stats: name={}, millis={}, counter={}, batchCounter={}", new Object[]{name, millis, counter, batchCounter});
        this.total.updateIndex(name, millis, counter, batchCounter);
        this.snapshot.updateIndex(name, millis, counter, batchCounter);
    }

    void reIndex(long numberRemoteOfOperations, long numberOfLocalOperations, long timeInMillis, boolean error) {
        log.trace("[INDEX-REPLAY] reIndex raw stats: numberRemoteOfOperations={}, numberOfLocalOperations={}, timeInMillis={}, error={}", new Object[]{numberRemoteOfOperations, numberOfLocalOperations, timeInMillis, error});
        if (numberRemoteOfOperations + numberOfLocalOperations > 0L) {
            if (numberRemoteOfOperations > 0L) {
                this.total.numberOfRemoteOperations.accept(numberRemoteOfOperations);
                this.snapshot.numberOfRemoteOperations.accept(numberRemoteOfOperations);
            }
            if (numberOfLocalOperations > 0L) {
                this.total.numberOfLocalOperations.accept(numberOfLocalOperations);
                this.snapshot.numberOfLocalOperations.accept(numberOfLocalOperations);
            }
            this.total.timeInMillis.accept(timeInMillis);
            this.snapshot.timeInMillis.accept(timeInMillis);
            this.total.errors.addAndGet(error ? 1 : 0);
            this.snapshot.errors.addAndGet(error ? 1 : 0);
        } else {
            this.total.numberOfZeroOperations.incrementAndGet();
            this.snapshot.numberOfZeroOperations.incrementAndGet();
        }
    }

    void logNotTooOften() {
        if (this.lastLogTime.elapsed(TimeUnit.SECONDS) > this.minLogFrequencyInSeconds) {
            this.log();
        }
    }

    void log() {
        this.total.logStats("total", this.currentNodeId);
        this.snapshot.logStats("snapshot", this.currentNodeId);
        this.snapshot.reset();
        this.lastLogTime.reset().start();
    }

    public ReIndexStats.Result total() {
        return this.total.get();
    }

    private class ReIndexStats {
        private final AtomicLong numberOfZeroOperations = new AtomicLong(0L);
        private final MutableLongStats numberOfRemoteOperations = new MutableLongStats(10L, 100L, 1000L, 10000L);
        private final MutableLongStats numberOfLocalOperations = new MutableLongStats(10L, 100L, 1000L, 10000L);
        private final MutableLongStats timeInMillis = new MutableLongStats(100L, 500L, 1000L, 5000L, 10000L, 30000L, 60000L);
        private final AtomicInteger errors = new AtomicInteger(0);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> compactInMillis = this.initImmutableMapForRequiredIndexes(0L, 1L, 10L);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> compactBeforeCounter = this.initImmutableMapForRequiredIndexes(new long[0]);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> compactAfterCounter = this.initImmutableMapForRequiredIndexes(new long[0]);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> compactVersionedCounter = this.initImmutableMapForRequiredIndexes(new long[0]);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> compactUnVersionedCounter = this.initImmutableMapForRequiredIndexes(new long[0]);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> filterOutAlreadyIndexedInMillis = this.initImmutableMapForRequiredIndexes(0L, 1L, 10L, 50L, 100L, 500L, 1000L);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> filterOutAlreadyIndexedBeforeCounter = this.initImmutableMapForRequiredIndexes(new long[0]);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> filterOutAlreadyIndexedAfterCounter = this.initImmutableMapForRequiredIndexes(new long[0]);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> updateIndexInMillis = this.initImmutableMapForRequiredIndexes(0L, 1L, 10L, 50L, 100L, 500L, 1000L, 5000L, 10000L, 30000L, 60000L, 300000L);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> updateIndexCounter = this.initImmutableMapForRequiredIndexes(new long[0]);
        private final Map<IndexDirectoryFactory.Name, MutableLongStats> updateIndexBatchCounter = this.initImmutableMapForRequiredIndexes(new long[0]);

        Map<IndexDirectoryFactory.Name, MutableLongStats> initImmutableMapForRequiredIndexes(long ... distribution) {
            return ImmutableMap.of((Object)((Object)IndexDirectoryFactory.Name.ISSUE), (Object)new MutableLongStats(distribution), (Object)((Object)IndexDirectoryFactory.Name.COMMENT), (Object)new MutableLongStats(distribution), (Object)((Object)IndexDirectoryFactory.Name.WORKLOG), (Object)new MutableLongStats(distribution));
        }

        ReIndexStats() {
        }

        void reset() {
            this.numberOfZeroOperations.set(0L);
            this.numberOfRemoteOperations.reset();
            this.numberOfLocalOperations.reset();
            this.timeInMillis.reset();
            this.errors.set(0);
            this.compactInMillis.forEach((name, stats) -> stats.reset());
            this.compactBeforeCounter.forEach((name, stats) -> stats.reset());
            this.compactAfterCounter.forEach((name, stats) -> stats.reset());
            this.compactVersionedCounter.forEach((name, stats) -> stats.reset());
            this.compactUnVersionedCounter.forEach((name, stats) -> stats.reset());
            this.filterOutAlreadyIndexedInMillis.forEach((name, stats) -> stats.reset());
            this.filterOutAlreadyIndexedBeforeCounter.forEach((name, stats) -> stats.reset());
            this.filterOutAlreadyIndexedAfterCounter.forEach((name, stats) -> stats.reset());
            this.updateIndexInMillis.forEach((name, stats) -> stats.reset());
            this.updateIndexCounter.forEach((name, stats) -> stats.reset());
            this.updateIndexBatchCounter.forEach((name, stats) -> stats.reset());
        }

        Result get() {
            return new Result();
        }

        void computeIfPresent(IndexDirectoryFactory.Name name, Map<IndexDirectoryFactory.Name, MutableLongStats> mutableLongStatsMap, long value) {
            MutableLongStats mutableLongStats = mutableLongStatsMap.get((Object)name);
            if (mutableLongStats != null) {
                mutableLongStats.accept(value);
            }
        }

        void compact(IndexDirectoryFactory.Name name, long millis, int beforeCounter, int afterCounter, int versionedCounter, int unVersionedCounter) {
            this.computeIfPresent(name, this.compactInMillis, millis);
            this.computeIfPresent(name, this.compactBeforeCounter, beforeCounter);
            this.computeIfPresent(name, this.compactAfterCounter, afterCounter);
            this.computeIfPresent(name, this.compactVersionedCounter, versionedCounter);
            this.computeIfPresent(name, this.compactUnVersionedCounter, unVersionedCounter);
        }

        void filterOutAlreadyIndexed(IndexDirectoryFactory.Name name, long millis, int beforeCounter, int afterCounter) {
            this.computeIfPresent(name, this.filterOutAlreadyIndexedInMillis, millis);
            this.computeIfPresent(name, this.filterOutAlreadyIndexedBeforeCounter, beforeCounter);
            this.computeIfPresent(name, this.filterOutAlreadyIndexedAfterCounter, afterCounter);
        }

        void updateIndex(IndexDirectoryFactory.Name name, long millis, int counter, int batchCounter) {
            this.computeIfPresent(name, this.updateIndexInMillis, millis);
            this.computeIfPresent(name, this.updateIndexCounter, counter);
            this.computeIfPresent(name, this.updateIndexBatchCounter, batchCounter);
        }

        void logStats(String statsName, String nodeId) {
            Gson gson = new Gson();
            log.info("[JIRA-STATS] [INDEX-REPLAY] [STATS] Node replay index operations stats ({}): nodeId={}, {}", new Object[]{statsName, nodeId, gson.toJson((Object)this.get())});
        }

        class Result {
            private final long numberOfZeroOperations;
            private final LongStats numberOfRemoteOperations;
            private final LongStats numberOfLocalOperations;
            private final LongStats timeInMillis;
            private final long errors;
            private final String period;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> compactInMillis;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> compactBeforeCounter;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> compactAfterCounter;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> compactVersionedCounter;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> compactUnVersionedCounter;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> filterOutAlreadyIndexedInMillis;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> filterOutAlreadyIndexedBeforeCounter;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> filterOutAlreadyIndexedAfterCounter;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> updateIndexInMillis;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> updateIndexCounter;
            private final ImmutableMap<IndexDirectoryFactory.Name, LongStats> updateIndexBatchCounter;

            Result() {
                this.numberOfZeroOperations = ReIndexStats.this.numberOfZeroOperations.get();
                this.numberOfRemoteOperations = ReIndexStats.this.numberOfRemoteOperations.get();
                this.numberOfLocalOperations = ReIndexStats.this.numberOfLocalOperations.get();
                this.timeInMillis = ReIndexStats.this.timeInMillis.get();
                this.errors = ReIndexStats.this.errors.get();
                this.period = ReIndexStatsLogger.this.lastLogTime.toString();
                this.compactInMillis = this.toImmutableMapStats(ReIndexStats.this.compactInMillis);
                this.compactBeforeCounter = this.toImmutableMapStats(ReIndexStats.this.compactBeforeCounter);
                this.compactAfterCounter = this.toImmutableMapStats(ReIndexStats.this.compactAfterCounter);
                this.compactVersionedCounter = this.toImmutableMapStats(ReIndexStats.this.compactVersionedCounter);
                this.compactUnVersionedCounter = this.toImmutableMapStats(ReIndexStats.this.compactUnVersionedCounter);
                this.filterOutAlreadyIndexedInMillis = this.toImmutableMapStats(ReIndexStats.this.filterOutAlreadyIndexedInMillis);
                this.filterOutAlreadyIndexedBeforeCounter = this.toImmutableMapStats(ReIndexStats.this.filterOutAlreadyIndexedBeforeCounter);
                this.filterOutAlreadyIndexedAfterCounter = this.toImmutableMapStats(ReIndexStats.this.filterOutAlreadyIndexedAfterCounter);
                this.updateIndexInMillis = this.toImmutableMapStats(ReIndexStats.this.updateIndexInMillis);
                this.updateIndexCounter = this.toImmutableMapStats(ReIndexStats.this.updateIndexCounter);
                this.updateIndexBatchCounter = this.toImmutableMapStats(ReIndexStats.this.updateIndexBatchCounter);
            }

            ImmutableMap<IndexDirectoryFactory.Name, LongStats> toImmutableMapStats(Map<IndexDirectoryFactory.Name, MutableLongStats> mutableMap) {
                return ImmutableMap.copyOf(mutableMap.entrySet().stream().filter(e -> ((MutableLongStats)e.getValue()).get().count > 0L).collect(Collectors.toMap(Map.Entry::getKey, e -> ((MutableLongStats)e.getValue()).get())));
            }

            public String toString() {
                Gson gson = new Gson();
                return gson.toJson((Object)this);
            }
        }
    }
}

