/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.instrumentation.InstrumentationLogger;
import com.atlassian.jira.instrumentation.LogEntry;
import com.atlassian.jira.instrumentation.RequestData;
import com.atlassian.jira.instrumentation.Statistics;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.logging.log4j.layout.JsonLayout;
import com.atlassian.logging.log4j.layout.json.DefaultJsonDataProvider;
import com.atlassian.plugin.event.events.PluginFrameworkShuttingDownEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.codehaus.jackson.map.ObjectMapper;

@ParametersAreNonnullByDefault
public class DefaultInstrumentationLogger
implements InstrumentationLogger,
InitializingComponent {
    protected static final String REQUEST_EXECUTION_TIME = "requestExecutionTime";
    protected static final String JIRA_INSTRUMENTATION_LAAS_PROPERTY = "jira.instrumentation.laas";
    private static final String JIRA_INSTRUMENTATION_BUFFER_SIZE = "jira.instrumentation.cache.buffersize";
    private static final String INSTRUMENTATION = "instrumentation";
    private static final int DEFAULT_BUFFER_SIZE = 100;
    private static final Logger logger = Logger.getLogger(DefaultInstrumentationLogger.class);
    public static final String SPAN_ID = "spanId";
    public static final String PARENT_SPAN_ID = "parentSpanId";
    private static final String REQUEST_START_NANO_TIME = "startNanoTime";
    private static final FeatureFlag LOGGING_TO_LAAS_FEATURE = JiraFeatureFlagRegistrar.registerFeatureFlag("jira.instrumentation.laas", false);
    private final Buffer instrumentationResults;
    private final ExecutorService pool = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("DefaultInstrumentationLogger-%d").build());
    private final FeatureManager featureManager;
    private final EventPublisher eventPublisher;
    private final boolean laasLoggingSystemPropertyState;

    public DefaultInstrumentationLogger(JiraProperties jiraProperties, FeatureManager featureManager, EventPublisher eventPublisher) {
        this.instrumentationResults = BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(jiraProperties.getInteger(JIRA_INSTRUMENTATION_BUFFER_SIZE) == null ? 100 : jiraProperties.getInteger(JIRA_INSTRUMENTATION_BUFFER_SIZE)));
        this.featureManager = featureManager;
        this.eventPublisher = eventPublisher;
        this.laasLoggingSystemPropertyState = jiraProperties.getBoolean(JIRA_INSTRUMENTATION_LAAS_PROPERTY);
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void pluginFrameworkShuttingDown(PluginFrameworkShuttingDownEvent pluginFrameworkShuttingDownEvent) {
        this.pool.shutdown();
    }

    @Override
    public void save(String traceId, String path, List<? extends Statistics> requestStats, Optional<Long> requestTime) {
        RequestData requestData = new RequestData.Builder().setPath(path).setTraceId(traceId).build();
        this.save(requestData, requestStats, requestTime);
    }

    @Override
    public void save(RequestData requestData, List<? extends Statistics> requestStats, Optional<Long> requestTime) {
        this.save(requestData, requestStats, requestTime, null);
    }

    @Override
    public void save(RequestData requestData, List<? extends Statistics> requestStats, Optional<Long> requestTime, @Nullable Exception exception) {
        if (requestStats.isEmpty()) {
            return;
        }
        Objects.requireNonNull(requestData, "requestData");
        Objects.requireNonNull(requestStats, "requestData");
        Objects.requireNonNull(requestTime, "requestTime");
        boolean enabled = this.isEnabled();
        CompletableFuture.runAsync(() -> {
            block9: {
                try {
                    Map<String, List<Statistics>> entryMap = requestStats.stream().collect(Collectors.groupingBy(Statistics::getLoggingKey));
                    String queryString = requestData.getQueryString().orElse(null);
                    String internalTraceId = requestData.getTraceId().orElseGet(() -> UUID.randomUUID().toString());
                    String internalPath = requestData.getPath().orElse(Thread.currentThread().getName());
                    LogEntry entry = new LogEntry(internalTraceId, internalPath, queryString, entryMap);
                    this.instrumentationResults.add((Object)entry);
                    if (!enabled) break block9;
                    try {
                        String logging = this.getJsonString(requestData.getSpanId(), requestData.getParentSpanId(), entry, requestTime, requestData.getStartNanoTime());
                        if (exception != null) {
                            logger.info((Object)logging, (Throwable)exception);
                        } else {
                            logger.info((Object)logging);
                        }
                    }
                    catch (RuntimeException e) {
                        logger.debug((Object)"failed to log to LaaS: ", (Throwable)e);
                    }
                    finally {
                        this.cleanMdc();
                    }
                }
                catch (RuntimeException e) {
                    logger.debug((Object)"failed to log instrumentation", (Throwable)e);
                }
            }
        }, this.pool);
    }

    protected String getJsonString(Optional<String> spanId, Optional<String> parentSpanId, LogEntry entry, Optional<Long> requestTime, Optional<Long> startNanoTime) {
        Objects.requireNonNull(entry);
        JsonLayout jsonLayout = new JsonLayout();
        jsonLayout.activateOptions();
        Jsonable json = writer -> new ObjectMapper().writeValue(writer, (Object)entry);
        MDC.put((String)DefaultJsonDataProvider.MdcKey.REQUEST_ID.getKey(), (Object)entry.getTraceId());
        MDC.put((String)REQUEST_EXECUTION_TIME, (Object)requestTime.orElse(-1L));
        startNanoTime.ifPresent(time -> MDC.put((String)REQUEST_START_NANO_TIME, (Object)time));
        spanId.ifPresent(span -> MDC.put((String)SPAN_ID, (Object)span));
        parentSpanId.ifPresent(parent -> MDC.put((String)PARENT_SPAN_ID, (Object)parent));
        MDC.put((String)INSTRUMENTATION, (Object)json);
        LoggingEvent event = new LoggingEvent(DefaultInstrumentationLogger.class.getCanonicalName(), (Category)logger, (Priority)Level.INFO, (Object)"", null);
        return jsonLayout.format(event);
    }

    protected void cleanMdc() {
        MDC.remove((String)INSTRUMENTATION);
        MDC.remove((String)SPAN_ID);
        MDC.remove((String)PARENT_SPAN_ID);
        MDC.remove((String)REQUEST_EXECUTION_TIME);
        MDC.remove((String)DefaultJsonDataProvider.MdcKey.REQUEST_ID.getKey());
    }

    @Override
    public List<LogEntry> getLogEntriesFromBuffer() {
        LogEntry[] logEntries = (LogEntry[])this.instrumentationResults.toArray((Object[])new LogEntry[this.instrumentationResults.size()]);
        return Arrays.stream(logEntries).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void clearMemoryBuffer() {
        this.instrumentationResults.clear();
    }

    @VisibleForTesting
    protected boolean isEnabled() {
        boolean flagEnabled = this.featureManager.isEnabled(LOGGING_TO_LAAS_FEATURE);
        if (this.laasLoggingSystemPropertyState) {
            if (flagEnabled) {
                return true;
            }
            DarkFeatures darkFeatures = this.featureManager.getDarkFeatures();
            return !darkFeatures.isFeatureEnabled(LOGGING_TO_LAAS_FEATURE.disabledFeatureKey());
        }
        return flagEnabled;
    }
}

