/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.jdbc;

import com.atlassian.instrumentation.caches.RequestListener;
import com.atlassian.instrumentation.driver.JdbcThreadLocalCollector;
import com.atlassian.jira.instrumentation.jdbc.StackTraceHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.stream.Collectors;

public class JdbcCollector
implements RequestListener {
    private static final String JDBC_LOGGING_KEY = "jdbc";
    private final boolean sqlExecutionTimesEnabled;

    public JdbcCollector(boolean sqlExecutionTimesEnabled) {
        this.sqlExecutionTimesEnabled = sqlExecutionTimesEnabled;
    }

    public String getName() {
        return JDBC_LOGGING_KEY;
    }

    public void onRequestStart() {
        JdbcThreadLocalCollector.start();
    }

    public String getLoggingKey() {
        return JDBC_LOGGING_KEY;
    }

    public Map<String, Object> onRequestEnd() {
        Map counts = JdbcThreadLocalCollector.getStatistics();
        Map medians = JdbcThreadLocalCollector.getMedianTime();
        Map executionTimes = JdbcThreadLocalCollector.getStartAndEndTimes();
        Map stackTraces = JdbcThreadLocalCollector.getStackTraces();
        JdbcThreadLocalCollector.clear();
        return counts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            HashMap<String, Object> r = new HashMap<String, Object>(6);
            String query = (String)entry.getKey();
            r.put("count", ((LongSummaryStatistics)entry.getValue()).getCount());
            r.put("average", ((LongSummaryStatistics)entry.getValue()).getAverage());
            r.put("median", medians.get(query));
            r.put("max", ((LongSummaryStatistics)entry.getValue()).getMax());
            r.put("min", ((LongSummaryStatistics)entry.getValue()).getMin());
            List traces = (List)stackTraces.get(query);
            if (traces != null) {
                List filtered = traces.stream().map(StackTraceHelper::filterStackTrace).collect(Collectors.toList());
                r.put("stackTraces", filtered);
            }
            if (this.sqlExecutionTimesEnabled) {
                r.put("xeqTimes", executionTimes.get(query));
            }
            return r;
        }));
    }

    public List<String> getTags() {
        return Collections.singletonList(JDBC_LOGGING_KEY);
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    private Map<String, Object> stackTraceToJson(StackTraceElement element) {
        return ImmutableMap.builder().put((Object)"class", (Object)element.getClassName()).put((Object)"method", (Object)element.getMethodName()).put((Object)"lineNumber", (Object)element.getLineNumber()).build();
    }
}

