/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.io;

import com.atlassian.jira.io.SessionTempFile;
import com.atlassian.jira.io.SessionTempFiles;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.annotation.Nonnull;

class SessionTempFileImpl
implements SessionTempFile {
    private final SessionTempFiles tempFiles;
    private final File file;

    public SessionTempFileImpl(SessionTempFiles tempFiles, File file) {
        this.tempFiles = (SessionTempFiles)Preconditions.checkNotNull((Object)tempFiles);
        this.file = (File)Preconditions.checkNotNull((Object)file);
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    public void unbind() {
        this.tempFiles.remove(this);
    }

    public boolean delete() {
        boolean deleted = this.file.delete();
        if (deleted) {
            this.unbind();
        }
        return deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionTempFileImpl that = (SessionTempFileImpl)o;
        if (!this.file.equals(that.file)) {
            return false;
        }
        return this.tempFiles.equals(that.tempFiles);
    }

    public int hashCode() {
        int result = this.tempFiles.hashCode();
        result = 31 * result + this.file.hashCode();
        return result;
    }

    public String toString() {
        return String.format("SessionTempFileImpl{session='%s', path='%s'}", this.tempFiles.getSessionId(), this.file.getAbsolutePath());
    }
}

