/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.ipd.InProductDiagnosticJob;
import com.atlassian.jira.ipd.InProductDiagnosticJobRunner;
import com.atlassian.jira.ipd.JmxMeasurementUpdater;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DefaultInProductDiagnosticJobRunner
implements InProductDiagnosticJobRunner,
JobRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultInProductDiagnosticJobRunner.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)DefaultInProductDiagnosticJobRunner.class.getName());
    private static final JobId JOB_ID = JobId.of((String)DefaultInProductDiagnosticJobRunner.class.getName());
    private static final long DEFAULT_INTERVAL_IN_MS = 60000L;
    private final Map<Class<?>, InProductDiagnosticJob> jobs;
    private final SchedulerService schedulerService;
    private final JmxMeasurementUpdater jmxMeasurementUpdater;
    private final FeatureManager featureManager;

    public DefaultInProductDiagnosticJobRunner(SchedulerService schedulerService, JmxMeasurementUpdater jmxMeasurementUpdater, FeatureManager featureManager) {
        this.schedulerService = schedulerService;
        this.jmxMeasurementUpdater = jmxMeasurementUpdater;
        this.jobs = new ConcurrentHashMap();
        this.featureManager = featureManager;
        this.registerJobRunner();
    }

    private void registerJobRunner() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)60000L, null));
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
            log.info("Job DefaultInProductDiagnosticJobRunner has been scheduled");
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule Job {}", (Object)JOB_ID, (Object)e);
        }
    }

    private void unregisterJobRunner() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        this.schedulerService.unscheduleJob(JOB_ID);
        log.info("Job DefaultInProductDiagnosticJobRunner has been unscheduled");
    }

    @Override
    public void register(InProductDiagnosticJob job) {
        this.jobs.put(job.getClass(), job);
        log.info(String.format("Job %s has been registered", job.getClass().getName()));
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS)) {
            log.debug(String.format("Not executing InProductDiagnosticJobs because %s is disabled", JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS));
            return JobRunnerResponse.success();
        }
        for (InProductDiagnosticJob job : this.jobs.values()) {
            log.debug(String.format("Running job %s", job.getClass().getName()));
            try {
                job.measure().forEach(this.jmxMeasurementUpdater::updateMeasures);
            }
            catch (RuntimeException ex) {
                log.error(String.format("Error during executing %s job", job.getClass().getName()), (Throwable)ex);
            }
        }
        return JobRunnerResponse.success();
    }

    public void destroy() throws Exception {
        this.unregisterJobRunner();
    }
}

