/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.db;

import com.atlassian.diagnostics.internal.platform.monitor.db.DatabasePoolDiagnostic;
import com.atlassian.diagnostics.internal.platform.monitor.db.DatabasePoolDiagnosticProvider;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.DatabaseConnectionStateService;
import com.atlassian.jira.ipd.InProductDiagnosticJob;
import com.atlassian.jira.ipd.InProductDiagnosticJobRunner;
import com.atlassian.jira.ipd.InProductDiagnosticMeasureType;
import com.atlassian.jira.ipd.InProductDiagnosticMeasurement;
import com.atlassian.jira.ipd.IpdMetricName;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

public class DatabaseConnectionPoolInProductDiagnosticJob
implements InProductDiagnosticJob {
    private final DatabaseConnectionStateService databaseConnectionStateService;

    public DatabaseConnectionPoolInProductDiagnosticJob(DatabaseConnectionStateService databaseConnectionStateService, InProductDiagnosticJobRunner inProductDiagnosticScheduler) {
        this.databaseConnectionStateService = databaseConnectionStateService;
        inProductDiagnosticScheduler.register(this);
    }

    @Override
    public List<InProductDiagnosticMeasurement> measure() {
        DatabaseConnectionStateService.DatabaseConnectionState dbState = this.databaseConnectionStateService.getState();
        DatabasePoolDiagnostic diagnostic = this.getDiagnostics();
        if (dbState == DatabaseConnectionStateService.DatabaseConnectionState.DISCONNECTED || diagnostic.isEmpty()) {
            return ImmutableList.of((Object)new InProductDiagnosticMeasurement(EnumSet.of(InProductDiagnosticMeasureType.LAST_VALUE), IpdMetricName.DB_CONNECTION_POOL_ACTIVE, -1L), (Object)new InProductDiagnosticMeasurement(EnumSet.of(InProductDiagnosticMeasureType.LAST_VALUE), IpdMetricName.DB_CONNECTION_POOL_IDLE, -1L));
        }
        return ImmutableList.of((Object)new InProductDiagnosticMeasurement(EnumSet.of(InProductDiagnosticMeasureType.LAST_VALUE, InProductDiagnosticMeasureType.STATS), IpdMetricName.DB_CONNECTION_POOL_ACTIVE, diagnostic.getActiveConnections()), (Object)new InProductDiagnosticMeasurement(EnumSet.of(InProductDiagnosticMeasureType.LAST_VALUE, InProductDiagnosticMeasureType.STATS), IpdMetricName.DB_CONNECTION_POOL_IDLE, diagnostic.getIdleConnections()));
    }

    private DatabasePoolDiagnostic getDiagnostics() {
        return Optional.ofNullable(ComponentAccessor.getOSGiComponentInstanceOfType(DatabasePoolDiagnosticProvider.class)).map(DatabasePoolDiagnosticProvider::getDiagnostic).orElse(DatabasePoolDiagnostic.EMPTY);
    }
}

