/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.FileAttachments;
import com.atlassian.jira.project.Project;

public final class AttachmentKeys {
    public static AttachmentKey from(Project project, Issue issue, Attachment attachment) {
        return AttachmentKeys.from(project.getOriginalKey(), issue.getKey(), attachment);
    }

    public static AttachmentKey from(String originalProjectKey, String issueKey, Attachment attachment) {
        return AttachmentKeys.from(originalProjectKey, issueKey, attachment.getFilename(), attachment.getId());
    }

    public static AttachmentKey from(String originalProjectKey, String issueKey, String fileName, Long id) {
        String compoundKey = FileAttachments.computeIssueKeyForOriginalProjectKey(originalProjectKey, issueKey);
        return new AttachmentKey(originalProjectKey, compoundKey, id, fileName);
    }

    public static AttachmentKey from(Attachment attachment) {
        return AttachmentKeys.from(attachment, attachment.getIssueObject());
    }

    public static AttachmentKey from(Attachment attachment, Issue issue) {
        Project project = issue.getProjectObject();
        return AttachmentKeys.from(project, issue, attachment);
    }

    private AttachmentKeys() {
    }
}

