/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.attachment.AttachmentDirectoryAccessor;
import com.atlassian.jira.issue.attachment.AttachmentStorageUnavailableException;
import com.atlassian.jira.issue.attachment.FileAttachments;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentStorageUnavailableException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.util.AttachmentException;
import io.atlassian.fugue.Option;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemAttachmentDirectoryAccessor
implements AttachmentDirectoryAccessor {
    private static final Logger log = LoggerFactory.getLogger(FileSystemAttachmentDirectoryAccessor.class);
    private static final String TMP_ATTACHMENTS = "tmp_attachments";
    protected final ProjectManager projectManager;
    private final AttachmentPathManager attachmentPathManager;

    public FileSystemAttachmentDirectoryAccessor(ProjectManager projectManager, AttachmentPathManager attachmentPathManager) {
        this.projectManager = projectManager;
        this.attachmentPathManager = attachmentPathManager;
    }

    @Override
    @Nonnull
    public File getThumbnailDirectory(@Nonnull Issue issue) {
        return this.getThumbnailDirectory(issue, true);
    }

    @Override
    @Nonnull
    public File getThumbnailDirectory(@Nonnull Issue issue, boolean createDirectory) {
        File thumbDir = new File(this.getAttachmentDirectory(issue, createDirectory), "thumbs");
        if (createDirectory && !thumbDir.exists() && !thumbDir.mkdirs()) {
            log.warn("Unable to make thumbnail directory " + thumbDir.getAbsolutePath());
        }
        return thumbDir;
    }

    @Override
    public File getAttachmentDirectory(@Nonnull Issue issue) {
        return this.getAttachmentDirectory(issue, true);
    }

    @Override
    @Nullable
    public File getAttachmentDirectory(@Nonnull String issueKey) {
        IssueKey ik = IssueKey.from((String)issueKey);
        Project project = this.projectManager.getProjectObjByKey(ik.getProjectKey());
        if (project != null) {
            return this.getAttachmentDirectory(this.getAttachmentDirName(), project.getOriginalKey(), IssueKey.format((String)project.getOriginalKey(), (long)ik.getIssueNumber()));
        }
        return null;
    }

    @Override
    public File getAttachmentDirectory(@Nonnull Issue issue, boolean createDirectory) {
        Project project = issue.getProjectObject();
        File directory = this.getAttachmentDirectory(this.getAttachmentDirName(), project.getKey(), issue.getKey());
        if (createDirectory) {
            directory.mkdirs();
        }
        return directory;
    }

    @Override
    public File getTemporaryAttachmentDirectory() {
        File cachesDirectory = ((JiraHome)ComponentAccessor.getComponent(JiraHome.class)).getCachesDirectory();
        File tempDirectory = new File(cachesDirectory, TMP_ATTACHMENTS);
        if (!tempDirectory.exists()) {
            tempDirectory.mkdirs();
        }
        return tempDirectory;
    }

    @Override
    public File getAttachmentDirectory(String attachmentDirectory, String projectKey, String issueKey) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        String projectOriginalKey = project == null ? projectKey : project.getOriginalKey();
        return FileAttachments.getAttachmentDirectoryForIssue(new File(attachmentDirectory), projectOriginalKey, issueKey);
    }

    @Override
    public void checkValidAttachmentDirectory(Issue issue) throws AttachmentException {
        try {
            File directory = this.getAttachmentDirectory(issue);
            if (!directory.canWrite()) {
                throw new AttachmentStorageUnavailableException(directory.getAbsolutePath());
            }
            this.checkValidTemporaryAttachmentDirectory();
        }
        catch (Exception e) {
            throw new AttachmentStorageUnavailableException((Throwable)e);
        }
    }

    @Override
    public void checkValidTemporaryAttachmentDirectory() throws AttachmentException {
        File tempDirectory = this.getTemporaryAttachmentDirectory();
        if (!tempDirectory.canWrite()) {
            throw new TemporaryAttachmentStorageUnavailableException(tempDirectory.getAbsolutePath());
        }
    }

    private String getAttachmentDirName() {
        String attachmentPath = this.attachmentPathManager.getAttachmentPath();
        return attachmentPath == null ? this.attachmentPathManager.getDefaultAttachmentPath() : attachmentPath;
    }

    @Override
    public File getAttachmentRootPath() {
        return new File(this.getAttachmentDirName());
    }

    @Override
    public Option<ErrorCollection> errors() {
        ErrorCollection errors = this.checkDirectoryHealth(this.getAttachmentRootPath());
        errors.addErrorCollection(this.checkDirectoryHealth(this.getTemporaryAttachmentDirectory()));
        if (errors.hasAnyErrors()) {
            return Option.some((Object)errors);
        }
        return Option.none();
    }

    private ErrorCollection checkDirectoryHealth(File path) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!(path == null || path.exists() && path.isDirectory() && path.canWrite())) {
            errors.addErrorMessage("attachment path [" + path + "] invalid");
        }
        return errors;
    }
}

