/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.zip;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.attachment.zip.ZipEntryNotFoundException;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.io.InputStreamConsumer;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentZipEntryStreamConsumer
implements InputStreamConsumer<Unit> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentZipEntryStreamConsumer.class);
    private final OutputStream outputStream;
    private final Consumer<ZipArchiveEntry> onZipEntryExists;
    private final int entryIndex;
    private final ApplicationProperties applicationProperties;

    public AttachmentZipEntryStreamConsumer(OutputStream outputStream, Consumer<ZipArchiveEntry> onZipEntryExists, int entryIndex, ApplicationProperties applicationProperties) {
        this.outputStream = outputStream;
        this.onZipEntryExists = onZipEntryExists;
        this.entryIndex = entryIndex;
        this.applicationProperties = applicationProperties;
    }

    public Unit withInputStream(InputStream inputStream) throws IOException, ZipEntryNotFoundException {
        ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream(inputStream);
        Option<ZipArchiveEntry> zipEntryOption = this.findZipEntryByIndex(zipArchiveInputStream, this.entryIndex);
        if (zipEntryOption.isEmpty()) {
            throw new ZipEntryNotFoundException("Could not find entry with index: " + this.entryIndex);
        }
        ZipArchiveEntry zipEntry = (ZipArchiveEntry)zipEntryOption.get();
        this.streamZipEntry(zipArchiveInputStream, zipEntry);
        return Unit.Unit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamZipEntry(ZipArchiveInputStream zipArchiveInputStream, ZipArchiveEntry zipEntry) throws IOException {
        long maxAttachmentSize = Long.parseLong(this.applicationProperties.getDefaultBackedString("webwork.multipart.maxSize"));
        try {
            this.onZipEntryExists.consume((Object)zipEntry);
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = zipArchiveInputStream.read(buffer))) {
                this.outputStream.write(buffer, 0, n);
                if (!this.checkIfZipReachedMaxAttachmentSize(maxAttachmentSize, zipArchiveInputStream.getUncompressedCount())) continue;
                LOGGER.error("Uncompressed data exceeds maximum attachment size property. File name: " + zipEntry.getName() + " Maximum size of attachment: " + maxAttachmentSize);
                throw new IOException("Uncompressed data exceeds maximum attachment size property. File name: " + zipEntry.getName());
            }
        }
        finally {
            IOUtil.shutdownStream((InputStream)zipArchiveInputStream);
        }
    }

    private Option<ZipArchiveEntry> findZipEntryByIndex(ZipArchiveInputStream zipInputStream, int entryIndex) throws IOException {
        try {
            ZipArchiveEntry entry = zipInputStream.getNextZipEntry();
            for (int i = 0; entry != null && i < entryIndex; ++i) {
                entry = zipInputStream.getNextZipEntry();
            }
            return Option.option((Object)entry);
        }
        catch (ZipException zipException) {
            LOGGER.warn("Error when looking for zip archive entry: {}", (Object)zipException.getMessage());
            return Option.none();
        }
    }

    private boolean checkIfZipReachedMaxAttachmentSize(long maxAttachmentSize, long uncompressedData) {
        return uncompressedData > maxAttachmentSize;
    }
}

