/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.DefaultNonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.GenericTextCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ExternalLinkInNewWindow;
import com.opensymphony.util.UrlUtils;
import java.util.Map;
import javax.annotation.Nonnull;

public class URLCFType
extends GenericTextCFType
implements ExportableCustomFieldType {
    private final ExternalLinkInNewWindow externalLinkInNewWindow;
    private final JiraAuthenticationContext authContext;

    public URLCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator, JiraAuthenticationContext jiraAuthenticationContext, ExternalLinkInNewWindow externalLinkInNewWindow) {
        super(customFieldValuePersister, genericConfigManager, textFieldCharacterLengthValidator, jiraAuthenticationContext);
        this.externalLinkInNewWindow = externalLinkInNewWindow;
        this.authContext = jiraAuthenticationContext;
    }

    public NonNullCustomFieldProvider getNonNullCustomFieldProvider() {
        return ((Object)((Object)this)).getClass() == URLCFType.class ? new DefaultNonNullCustomFieldProvider(this.customFieldValuePersister) : null;
    }

    public String getSingularObjectFromString(String string) throws FieldValidationException {
        String uri;
        String string2 = uri = string == null ? null : string.trim();
        if (!UrlUtils.verifyHierachicalURI((String)uri)) {
            throw new FieldValidationException("Not a valid URL");
        }
        return uri;
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitURL(this);
        }
        return super.accept(visitor);
    }

    public FieldExportParts getRepresentationFromIssue(Issue issue, CustomFieldExportContext context) {
        String value = (String)this.getValueFromIssue(context.getCustomField(), issue);
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)context.getCustomField().getId(), (String)context.getDefaultColumnHeader(), (String)value);
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map params = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (issue != null) {
            String url = (String)this.getValueFromIssue(field, issue);
            params.put("openInNewWindow", this.externalLinkInNewWindow.shouldOpenInNewWindow(this.authContext.getLoggedInUser(), url));
        }
        return params;
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitURL(URLCFType var1);
    }
}

