/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.option;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import io.atlassian.util.concurrent.LazyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class LazyLoadedOption
implements Option,
Comparable<Option> {
    private final GenericValue gv;
    private final OptionsManager optionsManager;
    private final FieldConfigManager fieldManager;
    private final LazyReference<FieldConfig> relatedField = new LazyReference<FieldConfig>(){

        protected FieldConfig create() throws Exception {
            return LazyLoadedOption.this.fieldManager.getFieldConfig(LazyLoadedOption.this.gv.getLong("customfieldconfig"));
        }
    };

    public LazyLoadedOption(GenericValue gv, OptionsManager optionsManager, FieldConfigManager fieldManager) {
        this.gv = gv;
        this.fieldManager = fieldManager;
        this.optionsManager = optionsManager;
    }

    public FieldConfig getRelatedCustomField() {
        return (FieldConfig)this.relatedField.get();
    }

    public Option getParentOption() {
        return this.optionsManager.findByOptionId(this.gv.getLong("parentoptionid"));
    }

    @Nonnull
    public List<Option> getChildOptions() {
        return this.optionsManager.findByParentId(this.getOptionId());
    }

    public List<Option> retrieveAllChildren(@Nullable List<Option> listToAddTo) {
        List<Option> children = this.getChildOptions();
        ArrayList<Option> result = listToAddTo != null ? listToAddTo : new ArrayList<Option>(children.size());
        for (Option childOption : children) {
            result.add(childOption);
            childOption.retrieveAllChildren(listToAddTo);
        }
        return result;
    }

    public Long getOptionId() {
        return this.gv.getLong("id");
    }

    public Long getSequence() {
        return this.gv.getLong("sequence");
    }

    public String getValue() {
        return this.gv.getString("value");
    }

    public Boolean getDisabled() {
        Boolean disabled = this.gv.getBoolean("disabled");
        return disabled != null ? disabled : false;
    }

    public void setValue(String value) {
        this.gv.set("value", (Object)value);
    }

    public void setSequence(Long sequence) {
        this.gv.set("sequence", (Object)sequence);
    }

    public void setDisabled(Boolean disabled) {
        this.gv.set("disabled", (Object)disabled);
    }

    public void store() {
        try {
            this.gv.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
    }

    public GenericValue getGenericValue() {
        return this.gv;
    }

    @Override
    public int compareTo(@Nonnull Option o) {
        return new CompareToBuilder().append((Object)this.getSequence(), (Object)o.getSequence()).append((Object)this.getOptionId(), (Object)o.getOptionId()).toComparison();
    }

    public boolean equals(Object o) {
        return o instanceof Option && Objects.equals(this.getOptionId(), ((Option)o).getOptionId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getOptionId());
    }

    public String toString() {
        return this.getValue();
    }
}

