/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cache.CacheLoader;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.RequestCacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.AffectedVersionsSystemField;
import com.atlassian.jira.issue.fields.AggregateEstimateSystemField;
import com.atlassian.jira.issue.fields.AggregateOriginalEstimateSystemField;
import com.atlassian.jira.issue.fields.AggregateProgressBarSystemField;
import com.atlassian.jira.issue.fields.AggregateTimeSpentSystemField;
import com.atlassian.jira.issue.fields.ArchivedDateSystemField;
import com.atlassian.jira.issue.fields.ArchivedUserSystemField;
import com.atlassian.jira.issue.fields.AssigneeSystemField;
import com.atlassian.jira.issue.fields.AttachmentSystemField;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.ComponentsSystemField;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CreatedSystemField;
import com.atlassian.jira.issue.fields.CreatorSystemField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DescriptionSystemField;
import com.atlassian.jira.issue.fields.DueDateSystemField;
import com.atlassian.jira.issue.fields.EnvironmentSystemField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.FixVersionsSystemField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.IssueLinksSystemField;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.KeySystemField;
import com.atlassian.jira.issue.fields.LabelsSystemField;
import com.atlassian.jira.issue.fields.LastViewedSystemField;
import com.atlassian.jira.issue.fields.MandatoryField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.OriginalEstimateSystemField;
import com.atlassian.jira.issue.fields.PrioritySystemField;
import com.atlassian.jira.issue.fields.ProgressBarSystemField;
import com.atlassian.jira.issue.fields.ProjectField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.ReporterSystemField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.ResolutionDateSystemField;
import com.atlassian.jira.issue.fields.ResolutionSystemField;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.SecurityLevelSystemField;
import com.atlassian.jira.issue.fields.StatusSystemField;
import com.atlassian.jira.issue.fields.SubTaskSystemField;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.fields.ThumbnailSystemField;
import com.atlassian.jira.issue.fields.TimeEstimateSystemField;
import com.atlassian.jira.issue.fields.TimeSpentSystemField;
import com.atlassian.jira.issue.fields.TimeTrackingSystemField;
import com.atlassian.jira.issue.fields.UnscreenableField;
import com.atlassian.jira.issue.fields.UpdatedSystemField;
import com.atlassian.jira.issue.fields.VotesSystemField;
import com.atlassian.jira.issue.fields.WatchesSystemField;
import com.atlassian.jira.issue.fields.WorkRatioSystemField;
import com.atlassian.jira.issue.fields.WorklogSystemField;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFieldManager
implements FieldManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFieldManager.class);
    private static final Predicate<Field> ORDERABLE = new IsOrderable();
    private static final List<Class<? extends Field>> SYSTEM_FIELD_CLASSES = ImmutableList.builder().add(ProjectSystemField.class).add(KeySystemField.class).add(SummarySystemField.class).add(IssueTypeSystemField.class).add(StatusSystemField.class).add(PrioritySystemField.class).add(ResolutionSystemField.class).add(AssigneeSystemField.class).add(ReporterSystemField.class).add(CreatorSystemField.class).add(CreatedSystemField.class).add(LastViewedSystemField.class).add(UpdatedSystemField.class).add(ArchivedDateSystemField.class).add(ArchivedUserSystemField.class).add(ResolutionDateSystemField.class).add(AffectedVersionsSystemField.class).add(FixVersionsSystemField.class).add(ComponentsSystemField.class).add(DueDateSystemField.class).add(VotesSystemField.class).add(WatchesSystemField.class).add(ThumbnailSystemField.class).add(OriginalEstimateSystemField.class).add(TimeEstimateSystemField.class).add(TimeSpentSystemField.class).add(WorkRatioSystemField.class).add(SubTaskSystemField.class).add(IssueLinksSystemField.class).add(AttachmentSystemField.class).add(EnvironmentSystemField.class).add(DescriptionSystemField.class).add(TimeTrackingSystemField.class).add(SecurityLevelSystemField.class).add(CommentSystemField.class).add(ProgressBarSystemField.class).add(AggregateProgressBarSystemField.class).add(AggregateTimeSpentSystemField.class).add(AggregateEstimateSystemField.class).add(AggregateOriginalEstimateSystemField.class).add(LabelsSystemField.class).add(WorklogSystemField.class).build();
    private volatile CustomFieldManager customFieldManager;
    private volatile FieldLayoutManager fieldLayoutManager;
    private final Map<String, Field> fields;
    private final Collection<OrderableField> orderableFields;
    private final Collection<NavigableField> navigableFields;
    private final Collection<SearchableField> searchableFields;
    private final RequestCache<Optional<ApplicationUser>, FieldLayoutSet> userVisibleFieldLayoutsCache;

    public DefaultFieldManager(RequestCacheFactory requestCacheFactory) {
        this(requestCacheFactory, SYSTEM_FIELD_CLASSES);
    }

    @VisibleForTesting
    DefaultFieldManager(RequestCacheFactory requestCacheFactory, List<Class<? extends Field>> systemFieldClasses) {
        this.fields = DefaultFieldManager.buildSystemFieldMap(systemFieldClasses);
        this.orderableFields = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.filter(this.fields.values(), ORDERABLE), OrderableField.class));
        this.navigableFields = ImmutableSet.copyOf((Iterable)Iterables.filter(this.fields.values(), NavigableField.class));
        this.searchableFields = ImmutableSet.copyOf((Iterable)Iterables.filter(this.fields.values(), SearchableField.class));
        this.userVisibleFieldLayoutsCache = requestCacheFactory.createRequestCache(DefaultFieldManager.class.getName() + ".userVisibleFieldLayoutsCache", (CacheLoader)new CacheLoader<Optional<ApplicationUser>, FieldLayoutSet>(){

            @Nonnull
            public FieldLayoutSet load(@Nonnull Optional<ApplicationUser> user) {
                return new FieldLayoutSet(user.orElse(null));
            }
        });
    }

    private static Map<String, Field> buildSystemFieldMap(List<Class<? extends Field>> systemFieldClasses) {
        ImmutableMap.Builder fieldsBuilder = ImmutableMap.builder();
        for (Class<? extends Field> fieldClass : systemFieldClasses) {
            Field field = ComponentManager.getInstance().loadComponent(fieldClass, Collections.emptyList());
            fieldsBuilder.put((Object)field.getId(), (Object)field);
        }
        return fieldsBuilder.build();
    }

    public Field getField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        return this.fields.get(id);
    }

    public Set<NavigableField> getAllAvailableNavigableFields() throws FieldException {
        try {
            Set<NavigableField> allAvailableFields = this.getAvailableNavigableFields();
            Set<FieldLayout> uniqueSchemes = this.getAllFieldLayouts();
            return this.getAvailableFields(allAvailableFields, uniqueSchemes);
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout.";
            LOG.error("Error retrieving field layout.", (Throwable)e);
            throw new FieldException("Error retrieving field layout.", (Throwable)e);
        }
    }

    public Set<NavigableField> getAvailableNavigableFields(ApplicationUser remoteUser) throws FieldException {
        HashSet<NavigableField> availableFields = new HashSet<NavigableField>();
        try {
            Set<FieldLayout> uniqueSchemes = this.getUniqueSchemes(Collections.emptyList(), Collections.emptyList(), remoteUser);
            Set<String> browsableProjects = DefaultFieldManager.getBrowsableProjectKeys(remoteUser);
            Set<NavigableField> allAvailableFields = this.getAvailableNavigableFields();
            for (NavigableField field : allAvailableFields) {
                if (this.isFieldHidden(uniqueSchemes, (Field)field)) continue;
                if (this.isCustomField((Field)field)) {
                    CustomField customField = this.getCustomField(field.getId());
                    if (!DefaultFieldManager.userHasPermissionToCustomFieldProjects(customField, browsableProjects)) continue;
                    availableFields.add(field);
                    continue;
                }
                availableFields.add(field);
            }
            return availableFields;
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout.";
            LOG.error("Error retrieving field layout.", (Throwable)e);
            throw new FieldException("Error retrieving field layout.", (Throwable)e);
        }
    }

    private static boolean userHasPermissionToCustomFieldProjects(CustomField customField, Set<String> browsableProjects) {
        if (customField.isAllProjects()) {
            return true;
        }
        List projects = customField.getAssociatedProjectObjects();
        if (projects == null) {
            return false;
        }
        for (Project project : projects) {
            if (!browsableProjects.contains(project.getKey())) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getBrowsableProjectKeys(ApplicationUser remoteUser) {
        Collection<Project> browsableProjectObjects = DefaultFieldManager.getBrowsableProjectObjects(remoteUser);
        HashSet<String> browsableProjectKeys = new HashSet<String>(browsableProjectObjects.size());
        for (Project project : browsableProjectObjects) {
            browsableProjectKeys.add(project.getKey());
        }
        return browsableProjectKeys;
    }

    public Set<SearchableField> getAllSearchableFields() {
        LinkedHashSet<SearchableField> fields = new LinkedHashSet<SearchableField>(this.searchableFields);
        fields.addAll(this.getCustomFieldManager().getCustomFieldObjects());
        return fields;
    }

    public Set<SearchableField> getSystemSearchableFields() {
        return new LinkedHashSet<SearchableField>(this.searchableFields);
    }

    public IssueTypeField getIssueTypeField() {
        return (IssueTypeField)this.getField("issuetype");
    }

    public ProjectField getProjectField() {
        return (ProjectField)this.getField("project");
    }

    public Set<NavigableField> getAvailableNavigableFieldsWithScope(ApplicationUser user) throws FieldException {
        return this.getAvailableNavigableFieldsWithScope(user, Collections.emptyList(), Collections.emptyList());
    }

    public Set<NavigableField> getAvailableNavigableFieldsWithScope(ApplicationUser remoteUser, QueryContext queryContext) throws FieldException {
        LinkedHashSet<NavigableField> allFields = new LinkedHashSet<NavigableField>();
        for (QueryContext.ProjectIssueTypeContexts context : queryContext.getProjectIssueTypeContexts()) {
            Set<NavigableField> availableFields = this.getAvailableNavigableFieldsWithScope(remoteUser, context.getProjectIdInList(), context.getIssueTypeIds());
            allFields.addAll(availableFields);
        }
        return allFields;
    }

    private Set<NavigableField> getAvailableNavigableFieldsWithScope(ApplicationUser remoteUser, List<Long> projectIds, List<String> issueTypes) throws FieldException {
        LinkedHashSet<NavigableField> availableFields = new LinkedHashSet<NavigableField>();
        try {
            Set<FieldLayout> schemes = this.getUniqueSchemes(projectIds, issueTypes, remoteUser);
            LinkedHashSet<NavigableField> allAvailableFields = new LinkedHashSet<NavigableField>();
            allAvailableFields.addAll(this.navigableFields);
            allAvailableFields.removeAll(this.getUnavailableFields());
            availableFields.addAll(this.getAvailableFields(allAvailableFields, schemes));
            availableFields.addAll(this.getAvailableCustomFieldsWithScope(remoteUser, projectIds, issueTypes));
            return availableFields;
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout.";
            LOG.error("Error retrieving field layout.", (Throwable)e);
            throw new FieldException("Error retrieving field layout.", (Throwable)e);
        }
    }

    private <F extends Field> Set<F> getAvailableFields(Collection<F> fieldsToCheck, Set<FieldLayout> schemes) {
        LinkedHashSet<Field> availableFields = new LinkedHashSet<Field>(fieldsToCheck.size());
        for (Field field : fieldsToCheck) {
            if (this.isFieldHidden(schemes, field)) continue;
            availableFields.add(field);
        }
        return availableFields;
    }

    public Set<CustomField> getAvailableCustomFields(ApplicationUser remoteUser, Issue issue) throws FieldException {
        Project project = issue.getProjectObject();
        List projectList = project == null ? Collections.emptyList() : CollectionBuilder.list((Object[])new Long[]{project.getId()});
        return this.getAvailableCustomFieldsWithScope(remoteUser, projectList, CollectionBuilder.list((Object[])new String[]{issue.getIssueTypeId()}));
    }

    private Set<CustomField> getAvailableCustomFieldsWithScope(ApplicationUser remoteUser, List<Long> projectIds, List<String> issueTypes) throws FieldException {
        CustomFieldManager customFieldManager = this.getCustomFieldManager();
        try {
            Set<FieldLayout> schemes = this.getUniqueSchemes(projectIds, issueTypes, remoteUser);
            Collection existingCustomFields = new HashSet();
            for (Long projectId : projectIds) {
                List existingCustomFieldsForProject = customFieldManager.getCustomFieldObjects(projectId, issueTypes);
                if (existingCustomFieldsForProject == null) continue;
                existingCustomFields.addAll(existingCustomFieldsForProject);
            }
            if (projectIds.isEmpty()) {
                existingCustomFields = customFieldManager.getCustomFieldObjects(null, issueTypes);
            }
            return this.getAvailableFields(existingCustomFields, schemes);
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout for " + (projectIds != null && !projectIds.isEmpty() ? "projects '" + projectIds + "'." : "null project.");
            LOG.error(message, (Throwable)e);
            throw new FieldException(message, (Throwable)e);
        }
    }

    @Nonnull
    private Set<FieldLayout> getUniqueSchemes(List<Long> projectIds, List<String> issueTypes, @Nullable ApplicationUser remoteUser) {
        if (projectIds.isEmpty() && issueTypes.isEmpty()) {
            return this.findVisibleFieldLayouts(DefaultFieldManager.getBrowsableProjectObjects(remoteUser), DefaultFieldManager.getAllIssueTypes());
        }
        if (projectIds.isEmpty()) {
            return this.findVisibleFieldLayouts(DefaultFieldManager.getBrowsableProjectObjects(remoteUser), issueTypes);
        }
        if (issueTypes.isEmpty()) {
            return this.findVisibleFieldLayouts(ComponentAccessor.getProjectManager().convertToProjectObjects(projectIds), DefaultFieldManager.getAllIssueTypes());
        }
        return this.findVisibleFieldLayouts(ComponentAccessor.getProjectManager().convertToProjectObjects(projectIds), issueTypes);
    }

    public boolean isFieldHidden(ApplicationUser remoteUser, String fieldId) {
        return this.isFieldHidden(remoteUser, this.getField(fieldId));
    }

    public boolean isFieldHidden(ApplicationUser remoteUser, Field field) {
        FieldLayoutSet fieldLayoutSet = (FieldLayoutSet)this.userVisibleFieldLayoutsCache.get(Optional.ofNullable(remoteUser));
        boolean isVisible = fieldLayoutSet.findAny((Predicate<Set<FieldLayout>>)((Predicate)fieldLayouts -> !this.isFieldHidden((Set<FieldLayout>)fieldLayouts, field)));
        return !isVisible;
    }

    public Set<FieldLayout> getVisibleFieldLayouts(ApplicationUser user) {
        return ((FieldLayoutSet)this.userVisibleFieldLayoutsCache.get(Optional.ofNullable(user))).findAll();
    }

    public boolean isFieldHidden(Set<FieldLayout> fieldLayouts, Field field) {
        return this.isOrderableField(field) && DefaultFieldManager.isFieldHidden(fieldLayouts, (OrderableField)field);
    }

    private static boolean isFieldHidden(Set<FieldLayout> fieldLayouts, OrderableField field) {
        for (FieldLayout fieldLayout : fieldLayouts) {
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(field);
            if (fieldLayoutItem == null) {
                LOG.error("FieldLayoutItem for field named {} with ID {} is null. Usually this is a transient race condition due to concurrent modification. Please contact Atlassian support if you see this log message frequently.", (Object)field.getName(), (Object)field.getId());
                continue;
            }
            if (fieldLayoutItem.isHidden()) continue;
            return false;
        }
        return true;
    }

    private Set<FieldLayout> getAllFieldLayouts() {
        return this.findVisibleFieldLayouts(ComponentAccessor.getProjectManager().getProjectObjects(), DefaultFieldManager.getAllIssueTypes());
    }

    private static List<String> getAllIssueTypes() {
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        return constantsManager.expandIssueTypeIds((Collection)ImmutableList.of((Object)"-4"));
    }

    private static Collection<Project> getBrowsableProjectObjects(ApplicationUser remoteUser) {
        return ComponentAccessor.getPermissionManager().getProjects(ProjectPermissions.BROWSE_PROJECTS, remoteUser);
    }

    @Nonnull
    private Set<FieldLayout> findVisibleFieldLayouts(Collection<Project> projects, List<String> issueTypes) {
        return this.getFieldLayoutManager().getUniqueFieldLayouts(projects, issueTypes);
    }

    public boolean isCustomField(String key) {
        return this.isExistingCustomField(key);
    }

    public boolean isCustomFieldId(String id) {
        return this.getCustomFieldManager().isCustomField(id);
    }

    public boolean isExistingCustomField(String id) {
        return this.getCustomFieldManager().exists(id);
    }

    public boolean isCustomField(Field field) {
        return field instanceof CustomField;
    }

    @Nullable
    public CustomField getCustomField(String key) {
        return this.getCustomFieldManager().getCustomFieldObject(key);
    }

    public boolean isHideableField(String id) {
        return this.isCustomField(id) || this.fields.get(id) instanceof HideableField;
    }

    public boolean isHideableField(Field field) {
        return field instanceof HideableField;
    }

    public HideableField getHideableField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        Field field = this.fields.get(id);
        if (field instanceof HideableField) {
            return (HideableField)field;
        }
        throw new IllegalArgumentException("The field with id '" + id + "' is not a HideableField.");
    }

    public boolean isOrderableField(String id) {
        return this.isCustomField(id) || ORDERABLE.apply((Object)this.fields.get(id));
    }

    public boolean isOrderableField(Field field) {
        return ORDERABLE.apply((Object)field);
    }

    @Nullable
    public OrderableField getOrderableField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        Field field = this.fields.get(id);
        return ORDERABLE.apply((Object)field) ? (OrderableField)field : null;
    }

    @Nullable
    public ConfigurableField getConfigurableField(String id) {
        OrderableField field = this.getOrderableField(id);
        if (field instanceof ConfigurableField) {
            return (ConfigurableField)field;
        }
        if (LOG.isInfoEnabled() && field != null) {
            LOG.info("Field found for " + id + " but was not a ConfigurableField. Type is " + field.getClass().getName() + " : " + field);
        }
        return null;
    }

    public Set<OrderableField> getOrderableFields() {
        return Collections.unmodifiableSet(this.getAvailableOrderableFields());
    }

    public Set<NavigableField> getNavigableFields() {
        return Collections.unmodifiableSet(this.getAvailableNavigableFields());
    }

    public boolean isNavigableField(String id) {
        return this.isCustomField(id) || this.isNavigableField(this.fields.get(id));
    }

    public boolean isNavigableField(Field field) {
        return field instanceof NavigableField;
    }

    public NavigableField getNavigableField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        Field field = this.fields.get(id);
        if (field instanceof NavigableField) {
            return (NavigableField)field;
        }
        throw new IllegalArgumentException("The field with id '" + id + "' is not a NavigableField.");
    }

    public boolean isRequirableField(String id) {
        return this.isCustomField(id) || this.fields.get(id) instanceof RequirableField;
    }

    public boolean isRequirableField(Field field) {
        return field instanceof RequirableField;
    }

    public boolean isMandatoryField(String id) {
        return !this.isCustomField(id) && this.isMandatoryField(this.fields.get(id));
    }

    public boolean isMandatoryField(Field field) {
        return field instanceof MandatoryField;
    }

    public boolean isRenderableField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id).isRenderable();
        }
        return this.fields.get(id) instanceof RenderableField;
    }

    public boolean isRenderableField(Field field) {
        if (this.isCustomField(field)) {
            return ((CustomField)field).isRenderable();
        }
        return field instanceof RenderableField;
    }

    public boolean isUnscreenableField(String id) {
        return !this.isCustomField(id) && this.fields.get(id) instanceof UnscreenableField;
    }

    public boolean isUnscreenableField(Field field) {
        return !this.isCustomField(field) && field instanceof UnscreenableField;
    }

    public RequirableField getRequiredField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        Field field = this.fields.get(id);
        if (field instanceof RequirableField) {
            return (RequirableField)field;
        }
        throw new IllegalArgumentException("The field with id '" + id + "' is not a RequirableField.");
    }

    private CustomFieldManager getCustomFieldManager() {
        if (this.customFieldManager == null) {
            this.customFieldManager = ComponentAccessor.getCustomFieldManager();
        }
        return this.customFieldManager;
    }

    private FieldLayoutManager getFieldLayoutManager() {
        if (this.fieldLayoutManager == null) {
            this.fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        }
        return this.fieldLayoutManager;
    }

    public void refresh() {
        this.refreshSearchersAndIndexers();
        this.getFieldLayoutManager().refresh();
        ComponentAccessor.getColumnLayoutManager().refresh();
    }

    public boolean isTimeTrackingOn() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.timetracking");
    }

    private static boolean isVotingOn() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.voting");
    }

    private static boolean isWatchingOn() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.watching");
    }

    private static boolean isSubTasksOn() {
        return ComponentAccessor.getSubTaskManager().isSubTasksEnabled();
    }

    private static boolean isArchivingOn() {
        return ((ArchivingLicenseCheck)ComponentAccessor.getComponent(ArchivingLicenseCheck.class)).isLicensedForIssueArchiving();
    }

    private Set<NavigableField> getAvailableNavigableFields() {
        return this.getAvailableFields(this.navigableFields);
    }

    private Set<OrderableField> getAvailableOrderableFields() {
        return this.getAvailableFields(this.orderableFields);
    }

    private <T extends Field> Set<T> getAvailableFields(Collection<T> allFields) {
        HashSet<T> availableFields = new HashSet<T>(allFields);
        availableFields.addAll(this.getCustomFieldManager().getCustomFieldObjects());
        availableFields.removeAll(this.getUnavailableFields());
        return availableFields;
    }

    public Set<Field> getUnavailableFields() {
        HashSet<Field> unavailableFields = new HashSet<Field>();
        if (!this.isTimeTrackingOn()) {
            unavailableFields.add(this.fields.get("timetracking"));
            unavailableFields.add(this.fields.get("timeoriginalestimate"));
            unavailableFields.add(this.fields.get("timeestimate"));
            unavailableFields.add(this.fields.get("timespent"));
            unavailableFields.add(this.fields.get("progress"));
            unavailableFields.add(this.fields.get("worklog"));
        }
        if (!DefaultFieldManager.isSubTasksOn() || !this.isTimeTrackingOn()) {
            unavailableFields.add(this.fields.get("aggregatetimespent"));
            unavailableFields.add(this.fields.get("aggregatetimeoriginalestimate"));
            unavailableFields.add(this.fields.get("aggregatetimeestimate"));
            unavailableFields.add(this.fields.get("aggregateprogress"));
        }
        if (!DefaultFieldManager.isVotingOn()) {
            unavailableFields.add(this.fields.get("votes"));
        }
        if (!DefaultFieldManager.isWatchingOn()) {
            unavailableFields.add(this.fields.get("watches"));
        }
        if (!DefaultFieldManager.isSubTasksOn()) {
            unavailableFields.add(this.fields.get("subtasks"));
        }
        if (!DefaultFieldManager.isArchivingOn()) {
            unavailableFields.add(this.fields.get("archivedby"));
            unavailableFields.add(this.fields.get("archiveddate"));
        }
        return unavailableFields;
    }

    private void refreshSearchersAndIndexers() {
        ((FieldConfigSchemeManager)ComponentAccessor.getComponent(FieldConfigSchemeManager.class)).init();
        IssueSearcherManager issueSearcherManager = (IssueSearcherManager)ComponentAccessor.getComponentOfType(IssueSearcherManager.class);
        issueSearcherManager.refresh();
        FieldIndexerManager fieldIndexerManager = (FieldIndexerManager)ComponentAccessor.getComponentOfType(FieldIndexerManager.class);
        fieldIndexerManager.refresh();
    }

    static class IsOrderable
    implements Predicate<Field> {
        IsOrderable() {
        }

        public boolean apply(Field field) {
            return field instanceof OrderableField && !(field instanceof ProjectSystemField);
        }
    }

    private final class FieldLayoutSet {
        private final ApplicationUser user;
        private final Set<FieldLayout> availableFieldLayouts = new HashSet<FieldLayout>();
        private final LinkedList<Project> unfilteredProjectObjects;

        private FieldLayoutSet(ApplicationUser user) {
            this.user = user;
            this.unfilteredProjectObjects = new LinkedList(ComponentAccessor.getProjectManager().getProjectObjects());
        }

        public boolean findAny(Predicate<Set<FieldLayout>> predicate) {
            Project project;
            if (predicate.apply(this.availableFieldLayouts)) {
                return true;
            }
            PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
            while ((project = this.unfilteredProjectObjects.poll()) != null) {
                if (!permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, this.user)) continue;
                HashSet newFieldLayouts = new HashSet(DefaultFieldManager.this.getFieldLayoutManager().getUniqueFieldLayouts(project));
                newFieldLayouts.removeAll(this.availableFieldLayouts);
                this.availableFieldLayouts.addAll(newFieldLayouts);
                if (!predicate.apply(newFieldLayouts)) continue;
                return true;
            }
            return false;
        }

        public Set<FieldLayout> findAll() {
            this.findAny((Predicate<Set<FieldLayout>>)((Predicate)t -> false));
            return new HashSet<FieldLayout>(this.availableFieldLayouts);
        }
    }
}

