/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.DCFeatureLicenseChecker;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.fields.AbstractTextSystemField;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.DefaultValueConfigItem;
import com.atlassian.jira.issue.fields.DefaultValueField;
import com.atlassian.jira.issue.fields.DefaultValueOperations;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.DescriptionRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.DescriptionSearchHandlerFactory;
import com.atlassian.jira.issue.search.parameters.lucene.sort.StringSortComparatorSource;
import com.atlassian.jira.issue.statistics.TextFieldSorter;
import com.atlassian.jira.issue.transport.impl.ActionParamsImpl;
import com.atlassian.jira.mention.MentionService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import webwork.action.Action;

public class DescriptionSystemField
extends AbstractTextSystemField
implements HideableField,
RequirableField,
RestFieldOperations,
DefaultValueField<String> {
    public static final String DEFAULT_VALUE_TYPE = "DefaultValue";
    private static final String DESCRIPTION_NAME_KEY = "issue.field.description";
    private static final LuceneFieldSorter SORTER = new TextFieldSorter("sort_description");
    private final RendererManager rendererManager;
    private final MentionService mentionService;
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;
    private final GenericConfigManager genericConfigManager;
    private final DCFeatureLicenseChecker licenseChecker;

    public DescriptionSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, RendererManager rendererManager, PermissionManager permissionManager, DescriptionSearchHandlerFactory searchHandlerFactory, MentionService mentionService, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator, GenericConfigManager genericConfigManager, DCFeatureLicenseChecker licenseChecker) {
        super("description", DESCRIPTION_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, rendererManager, permissionManager, searchHandlerFactory);
        this.rendererManager = rendererManager;
        this.mentionService = mentionService;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
        this.genericConfigManager = genericConfigManager;
        this.licenseChecker = licenseChecker;
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String description = (String)fieldValuesHolder.get(this.getId());
        if (fieldScreenRenderLayoutItem != null && fieldScreenRenderLayoutItem.isRequired() && (!TextUtils.stringSet((String)description) || description.trim().length() <= 0)) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
        }
        this.validateFieldLength(description, errorCollectionToAddTo, i18n);
    }

    private void validateFieldLength(@Nullable String description, @Nonnull ErrorCollection errors, I18nHelper i18n) {
        if (this.textFieldCharacterLengthValidator.isTextTooLong(description)) {
            long maximumNumberOfCharacters = this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters();
            errors.addError(this.getId(), i18n.getText("field.error.text.toolong", (Object)maximumNumberOfCharacters));
        }
    }

    @Override
    protected void populateVelocityParams(Map fieldValuesHolder, Map params) {
        super.populateVelocityParams(fieldValuesHolder, params);
        params.put("mentionable", this.mentionService.isUserAbleToMention(this.authenticationContext.getUser()));
    }

    @Override
    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
        super.populateDefaults(fieldValuesHolder, issue);
        FieldConfig relevantConfig = this.getRelevantConfig((IssueContext)issue);
        if (relevantConfig == null) {
            return;
        }
        if (!this.isLicensedForDefaultValues()) {
            return;
        }
        this.getDefaultValueOperations().populateDefaults(relevantConfig, fieldValuesHolder);
    }

    private boolean isLicensedForDefaultValues() {
        return this.licenseChecker.isEnabled(JiraFeatureFlagRegistrar.DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
    }

    public String getDefaultValue(Issue issue) {
        return (String)this.getDefaultValueOperations().getDefaultValue(this.getRelevantConfig((IssueContext)issue));
    }

    @Override
    public String getValueFromIssue(Issue issue) {
        return issue.getDescription();
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            String desc = (String)this.rendererManager.getRendererForType(rendererType).transformFromEdit((Object)this.getValueFromParams(fieldValueHolder));
            if (TextUtils.stringSet((String)desc)) {
                issue.setDescription(desc);
            } else {
                issue.setDescription(null);
            }
        }
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setDescription(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.description";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return SORTER;
    }

    @Override
    public List<SortField> getSortFields(boolean sortOrder) {
        return Collections.singletonList(new SortField("sort_description", (FieldComparatorSource)new StringSortComparatorSource(), sortOrder));
    }

    @Override
    protected String getEditTemplateName() {
        return "description-edit.vm";
    }

    @Override
    protected String getColumnViewTemplateName() {
        return "description-columnview.vm";
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        String rendererType = null;
        for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
            if (fieldLayout.isFieldHidden(this.getId())) {
                return "bulk.edit.unavailable.hidden";
            }
            if (rendererType == null) {
                rendererType = fieldLayout.getRendererTypeForField("description");
                continue;
            }
            if (rendererType.equals(fieldLayout.getRendererTypeForField("description"))) continue;
            return "bulk.edit.unavailable.different.renderers";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.unavailable.permission";
        }
        return null;
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new DescriptionRestFieldOperationsHandler(this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        Object defaultValue = this.getDefaultValueOperations().getDefaultValue(this.getRelevantConfig(issueCtx));
        return defaultValue == null ? null : new JsonData(defaultValue);
    }

    public List<FieldConfigItemType> getConfigurationItemTypes() {
        return ImmutableList.of((Object)new DefaultValueConfigItem(this));
    }

    public List<Project> getAssociatedProjectObjects() {
        return ((FieldConfigSchemeManager)ComponentAccessor.getComponent(FieldConfigSchemeManager.class)).getAssociatedProjectObjects((ConfigurableField)this);
    }

    public FieldConfig getRelevantConfig(IssueContext issueContext) {
        return ((FieldConfigSchemeManager)ComponentAccessor.getComponent(FieldConfigSchemeManager.class)).getRelevantConfig(issueContext, (ConfigurableField)this);
    }

    public DefaultValueOperations<String> getDefaultValueOperations() {
        return new DefaultValueOperations<String>(){

            public String getDefaultValue(@Nonnull FieldConfig fieldConfig) {
                if (fieldConfig == null) {
                    return null;
                }
                Object databaseValue = DescriptionSystemField.this.genericConfigManager.retrieve(DescriptionSystemField.DEFAULT_VALUE_TYPE, fieldConfig.getId().toString());
                if (databaseValue != null) {
                    return databaseValue.toString();
                }
                return null;
            }

            public void setDefaultValue(@Nonnull FieldConfig fieldConfig, @Nullable String value) {
                DescriptionSystemField.this.genericConfigManager.update(DescriptionSystemField.DEFAULT_VALUE_TYPE, fieldConfig.getId().toString(), (Object)value);
            }

            public void populateDefaults(@Nonnull FieldConfig fieldConfig, @Nonnull Map<String, Object> fieldValuesHolder) {
                String defaultValue = StringUtils.defaultString((String)this.getDefaultValue(fieldConfig));
                fieldValuesHolder.put(fieldConfig.getConfigurableField().getId(), defaultValue);
            }

            public String getViewHtml(@Nonnull FieldConfig fieldConfig, @Nullable FieldLayoutItem fieldLayoutItem) {
                String defaultValue = this.getDefaultValue(fieldConfig);
                String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
                return DescriptionSystemField.this.rendererManager.getRenderedContent(rendererType, defaultValue, null);
            }

            public String getEditHtml(@Nonnull FieldConfig config, @Nonnull Map customFieldValuesHolder, Action action, Map displayParameters, FieldLayoutItem fieldLayoutItem) {
                Map<String, Object> velocityParams = DescriptionSystemField.this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
                DescriptionSystemField.this.populateVelocityParams(customFieldValuesHolder, velocityParams);
                String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
                velocityParams.put("rendererDescriptor", DescriptionSystemField.this.rendererManager.getRendererForType(rendererType).getDescriptor());
                return DescriptionSystemField.this.renderTemplate(DescriptionSystemField.this.getEditTemplateName(), velocityParams);
            }

            public boolean isSupport() {
                return true;
            }

            public void validateFromActionParams(@Nonnull FieldConfig config, @Nonnull Map actionParameters, @Nonnull ErrorCollection errorCollection) {
                ActionParamsImpl params = new ActionParamsImpl(actionParameters);
                String description = params.getFirstValueForKey(DescriptionSystemField.this.getId());
                DescriptionSystemField.this.validateFieldLength(description, errorCollection, ComponentAccessor.getJiraAuthenticationContext().getI18nHelper());
            }
        };
    }
}

