/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.field.CustomFieldUpdatedEvent;
import com.atlassian.jira.event.property.BooleanApplicationPropertySetEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public abstract class AbstractFieldLayoutManager
implements FieldLayoutManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFieldLayoutManager.class);
    public static final String FIELD_LAYOUT = "FieldLayout";
    public static final String SCHEME = "FieldLayoutScheme";
    public static final String SCHEME_ASSOCIATION = "ProjectFieldLayoutScheme";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String TYPE = "type";
    private static final Map<String, Object> IS_TYPE_DEFAULT = ImmutableMap.of((Object)"type", (Object)"default");
    protected final FieldManager fieldManager;
    protected final OfBizDelegator ofBizDelegator;
    protected final I18nHelper.BeanFactory i18nFactory;
    private final List<FieldLayoutItem> defaultFieldLayoutItems;
    static final Long NULL_ID_SENTINEL = -1L;
    private final Cache<Long, FieldLayout> fieldLayoutCache;
    private final ApplicationProperties applicationProperties;

    public AbstractFieldLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator, I18nHelper.BeanFactory i18nFactory, CacheManager cacheManager, ApplicationProperties applicationProperties) {
        this.fieldManager = (FieldManager)Assertions.notNull((String)"fieldManager", (Object)fieldManager);
        this.ofBizDelegator = ofBizDelegator;
        this.i18nFactory = i18nFactory;
        this.defaultFieldLayoutItems = this.createDefaultFieldLayoutItems(fieldManager);
        this.fieldLayoutCache = cacheManager.getCache(AbstractFieldLayoutManager.class.getName() + ".fieldLayoutCache", (CacheLoader)new FieldLayoutCacheLoader(), new CacheSettingsBuilder().build());
        this.applicationProperties = applicationProperties;
    }

    private List<FieldLayoutItem> createDefaultFieldLayoutItems(FieldManager fieldManager) {
        I18nHelper i18n = this.i18nFactory.getInstance((ApplicationUser)null);
        return ImmutableList.builder().add((Object)this.createDefaultItem(fieldManager, i18n, "summary", true)).add((Object)this.createDefaultItem(fieldManager, i18n, "issuetype", true)).add((Object)this.createDefaultItem(fieldManager, i18n, "security", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "priority", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "duedate", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "archiveddate", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "components", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "versions", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "fixVersions", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "assignee", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "reporter", true)).add((Object)this.createDefaultItem(fieldManager, i18n, "archivedby", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "environment", false)).add((Object)this.createDefaultItem(fieldManager, i18n, DESCRIPTION, false)).add((Object)this.createDefaultItem(fieldManager, i18n, "timetracking", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "resolution", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "attachment", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "comment", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "labels", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "worklog", false)).add((Object)this.createDefaultItem(fieldManager, i18n, "issuelinks", false)).build();
    }

    private FieldLayoutItem createDefaultItem(FieldManager fieldManager, I18nHelper i18n, String fieldId, boolean required) {
        return new FieldLayoutItemImpl.Builder().setOrderableField(fieldManager.getOrderableField(fieldId)).setFieldDescription(this.getDefaultDescription(i18n, fieldId)).setHidden(false).setRequired(required).setFieldManager(fieldManager).build();
    }

    @EventListener
    public void onCustomFieldUpdated(CustomFieldUpdatedEvent event) {
        this.fieldLayoutCache.removeAll();
    }

    protected List<FieldLayoutItem> getDefaultFieldLayoutItems() {
        return this.defaultFieldLayoutItems;
    }

    public FieldLayout getFieldLayout() {
        return this.getRelevantFieldLayout(null);
    }

    public FieldLayout getFieldLayout(Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        return this.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeId());
    }

    public EditableDefaultFieldLayout getEditableDefaultFieldLayout() {
        FieldLayout relevantFieldLayout = this.getRelevantFieldLayout(null);
        return new EditableDefaultFieldLayoutImpl(relevantFieldLayout.getGenericValue(), relevantFieldLayout.getFieldLayoutItems());
    }

    public void storeEditableDefaultFieldLayout(EditableDefaultFieldLayout editableDefaultFieldLayout) {
        this.storeEditableFieldLayout((EditableFieldLayout)editableDefaultFieldLayout);
        this.refreshCaches(editableDefaultFieldLayout.getId());
        this.refreshCaches(null);
    }

    public synchronized EditableFieldLayout storeAndReturnEditableFieldLayout(EditableFieldLayout editableFieldLayout) {
        try {
            OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
            GenericValue fieldLayoutGV = editableFieldLayout.getGenericValue();
            if (editableFieldLayout.getGenericValue() == null) {
                fieldLayoutGV = ofBizDelegator.createValue(FIELD_LAYOUT, (Map)FieldMap.build((String)NAME, (Object)editableFieldLayout.getName(), (String)DESCRIPTION, (Object)editableFieldLayout.getDescription(), (String)TYPE, (Object)editableFieldLayout.getType()));
            } else {
                fieldLayoutGV.store();
            }
            List fieldLayoutItemGVs = fieldLayoutGV.getRelated("ChildFieldLayoutItem");
            ofBizDelegator.removeAll(fieldLayoutItemGVs);
            List fieldLayoutItems = editableFieldLayout.getFieldLayoutItems();
            Long newId = fieldLayoutGV.getLong("id");
            for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
                ofBizDelegator.createValue("FieldLayoutItem", (Map)new FieldMap().add("fieldlayout", (Object)newId).add(DESCRIPTION, (Object)fieldLayoutItem.getRawFieldDescription()).add("fieldidentifier", (Object)fieldLayoutItem.getOrderableField().getId()).add("ishidden", (Object)Boolean.toString(fieldLayoutItem.isHidden())).add("isrequired", (Object)Boolean.toString(fieldLayoutItem.isRequired())).add("renderertype", (Object)fieldLayoutItem.getRendererType()));
            }
            this.refreshCaches(newId);
            return this.getEditableFieldLayout(newId);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Could not load the default FieldLayout", (Throwable)e);
        }
    }

    public void storeEditableFieldLayout(EditableFieldLayout editableFieldLayout) {
        this.storeAndReturnEditableFieldLayout(editableFieldLayout);
    }

    protected void refreshCaches(Long id) {
        this.fieldLayoutCache.remove((Object)(id == null ? NULL_ID_SENTINEL : id));
        ComponentAccessor.getColumnLayoutManager().refresh();
    }

    public boolean hasDefaultFieldLayout() {
        OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
        GenericValue fieldLayoutGV = EntityUtil.getOnly((List)ofBizDelegator.findByAnd(FIELD_LAYOUT, IS_TYPE_DEFAULT));
        return fieldLayoutGV == null;
    }

    public void restoreDefaultFieldLayout() {
        OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
        try {
            GenericValue fieldLayoutGV = EntityUtil.getOnly((List)ofBizDelegator.findByAnd(FIELD_LAYOUT, IS_TYPE_DEFAULT));
            if (fieldLayoutGV != null) {
                fieldLayoutGV.removeRelated("ChildFieldLayoutItem");
                fieldLayoutGV.remove();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.refresh();
    }

    protected synchronized void restoreFieldLayout(Long id) {
        try {
            OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
            GenericValue fieldLayoutGV = ofBizDelegator.findById(FIELD_LAYOUT, id);
            if (fieldLayoutGV != null) {
                List fieldLayoutItemGVs = fieldLayoutGV.getRelated("ChildFieldLayoutItem");
                ofBizDelegator.removeAll(fieldLayoutItemGVs);
                fieldLayoutGV.remove();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.refresh();
    }

    public void refresh() {
        this.fieldLayoutCache.removeAll();
    }

    protected FieldLayout getRelevantFieldLayout(Long id) {
        return (FieldLayout)this.fieldLayoutCache.get((Object)(id == null ? NULL_ID_SENTINEL : id));
    }

    private GenericValue loadDefaultFieldLayoutGenericValue() throws GenericEntityException {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd(FIELD_LAYOUT, IS_TYPE_DEFAULT));
    }

    private GenericValue loadFieldLayoutGenericValue(Long id) throws GenericEntityException {
        GenericValue fieldLayoutGV;
        if (id != null && (fieldLayoutGV = this.ofBizDelegator.findById(FIELD_LAYOUT, id)) != null) {
            return fieldLayoutGV;
        }
        return this.loadDefaultFieldLayoutGenericValue();
    }

    private List<FieldLayoutItem> loadInitialFieldLayoutItems(FieldLayout resultingLayout) {
        ArrayList<FieldLayoutItem> fieldLayoutItems = new ArrayList<FieldLayoutItem>(this.defaultFieldLayoutItems.size());
        Iterables.addAll(fieldLayoutItems, (Iterable)Iterables.transform(this.defaultFieldLayoutItems, (Function)new SetFieldLayoutAndManager(resultingLayout)));
        List customFieldObjects = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects();
        for (CustomField customField : customFieldObjects) {
            fieldLayoutItems.add(this.mapCustomField(resultingLayout, customField));
        }
        return fieldLayoutItems;
    }

    private List<FieldLayoutItem> loadFieldLayoutItems(FieldLayout resultingLayout, GenericValue fieldLayoutGV) throws GenericEntityException {
        if (fieldLayoutGV == null) {
            return this.loadInitialFieldLayoutItems(resultingLayout);
        }
        HashSet<String> seenFieldIds = new HashSet<String>(256);
        ArrayList<FieldLayoutItem> fieldLayoutItems = new ArrayList<FieldLayoutItem>(256);
        List related = fieldLayoutGV.getRelated("ChildFieldLayoutItem");
        for (GenericValue fieldLayoutItemGV : related) {
            String fieldId = fieldLayoutItemGV.getString("fieldidentifier");
            if (this.fieldManager.isOrderableField(fieldId)) {
                seenFieldIds.add(fieldId);
                fieldLayoutItems.add(this.toFieldLayoutItem(resultingLayout, fieldLayoutItemGV, fieldId));
                continue;
            }
            LOG.debug("Field layout contains non-orderable field with id '{}'.", (Object)fieldId);
        }
        Set orderableFields = this.fieldManager.getOrderableFields();
        for (OrderableField orderableField : orderableFields) {
            if (!seenFieldIds.add(orderableField.getId())) continue;
            FieldLayoutItemImpl fieldLayoutItem = this.mapOrderableField(resultingLayout, orderableField);
            fieldLayoutItems.add(fieldLayoutItem);
        }
        return fieldLayoutItems;
    }

    private FieldLayout loadFieldLayout(Long id) {
        try {
            GenericValue fieldLayoutGV = this.loadFieldLayoutGenericValue(id);
            FieldLayoutImpl resultingLayout = new FieldLayoutImpl(fieldLayoutGV, null);
            List<FieldLayoutItem> fieldLayoutItems = fieldLayoutGV == null ? this.loadInitialFieldLayoutItems(resultingLayout) : this.loadFieldLayoutItems(resultingLayout, fieldLayoutGV);
            this.removeUnavailableFields(fieldLayoutItems);
            resultingLayout.setFieldLayoutItems(new ArrayList<FieldLayoutItem>(fieldLayoutItems));
            return resultingLayout;
        }
        catch (GenericEntityException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new DataAccessException("Could not retrieve Field Layout.", (Throwable)e);
        }
    }

    private FieldLayoutItemImpl toFieldLayoutItem(FieldLayout resultingLayout, GenericValue fieldLayoutItemGV, String fieldId) {
        boolean isRequired = "assignee".equals(fieldId) ? !this.applicationProperties.getOption("jira.option.allowunassigned") : Boolean.valueOf(fieldLayoutItemGV.getString("isrequired"));
        return new FieldLayoutItemImpl.Builder().setOrderableField(this.fieldManager.getOrderableField(fieldId)).setFieldDescription(fieldLayoutItemGV.getString(DESCRIPTION)).setHidden(Boolean.valueOf(fieldLayoutItemGV.getString("ishidden"))).setRequired(isRequired).setRendererType(fieldLayoutItemGV.getString("renderertype")).setFieldLayout(resultingLayout).setFieldManager(this.fieldManager).build();
    }

    private FieldLayoutItemImpl mapOrderableField(FieldLayout resultingLayout, OrderableField orderableField) {
        return new FieldLayoutItemImpl.Builder().setOrderableField(orderableField).setFieldDescription(this.getDefaultDescription(orderableField.getId())).setHidden(false).setRequired(this.fieldManager.isMandatoryField((Field)orderableField)).setFieldLayout(resultingLayout).setFieldManager(this.fieldManager).build();
    }

    private void removeUnavailableFields(List<FieldLayoutItem> fieldLayoutItems) {
        Set unavailableFields = this.fieldManager.getUnavailableFields();
        Iterator<FieldLayoutItem> iterator = fieldLayoutItems.iterator();
        while (iterator.hasNext()) {
            if (!unavailableFields.contains(iterator.next().getOrderableField())) continue;
            iterator.remove();
        }
    }

    private FieldLayoutItem mapCustomField(FieldLayout resultingLayout, CustomField customField) {
        return new FieldLayoutItemImpl.Builder().setOrderableField((OrderableField)customField).setFieldDescription(null).setFieldLayout(resultingLayout).setFieldManager(this.fieldManager).build();
    }

    protected String getDefaultDescription(String fieldId) {
        return this.getDefaultDescription(this.getI18nHelper(), fieldId);
    }

    private String getDefaultDescription(I18nHelper i18n, String fieldId) {
        if ("environment".equals(fieldId)) {
            return i18n.getText("environment.field.description");
        }
        if ("timetracking".equals(fieldId)) {
            return i18n.getText("timetracking.field.description", "*w *d *h *m", "4d, 5h 30m, 60m", "3w");
        }
        if ("worklog".equals(fieldId)) {
            return i18n.getText("worklog.field.description");
        }
        return null;
    }

    protected I18nHelper getI18nHelper() {
        return this.i18nFactory.getInstance((ApplicationUser)null);
    }

    @EventListener
    public void refreshCacheWhenUpdateAllowUnassignedOption(BooleanApplicationPropertySetEvent booleanApplicationPropertySetEvent) {
        if ("jira.option.allowunassigned".equals(booleanApplicationPropertySetEvent.getPropertyKey())) {
            this.refresh();
        }
    }

    class SetFieldLayoutAndManager
    implements Function<FieldLayoutItem, FieldLayoutItem> {
        private final FieldLayout fieldLayout;

        SetFieldLayoutAndManager(FieldLayout fieldLayout) {
            this.fieldLayout = fieldLayout;
        }

        public FieldLayoutItem apply(FieldLayoutItem item) {
            return new FieldLayoutItemImpl.Builder(item).setFieldManager(AbstractFieldLayoutManager.this.fieldManager).setFieldLayout(this.fieldLayout).build();
        }
    }

    private class FieldLayoutCacheLoader
    implements CacheLoader<Long, FieldLayout> {
        private FieldLayoutCacheLoader() {
        }

        public FieldLayout load(Long from) {
            return AbstractFieldLayoutManager.this.loadFieldLayout(from == NULL_ID_SENTINEL ? null : from);
        }
    }
}

