/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.issue.fields.rest.ProjectSuggestionProvider;
import com.atlassian.jira.issue.fields.rest.json.SuggestionBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.SuggestionGroupBean;
import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;

public class ProjectSuggestionProviderImpl
implements ProjectSuggestionProvider {
    private static final int MAX_RECENT_PROJECTS = 6;
    private final SuggestionBeanFactory suggestionBeanFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final UserProjectHistoryManager projectHistoryManager;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;

    public ProjectSuggestionProviderImpl(SuggestionBeanFactory suggestionBeanFactory, JiraAuthenticationContext authenticationContext, UserProjectHistoryManager projectHistoryManager, PermissionManager permissionManager, ProjectManager projectManager) {
        this.suggestionBeanFactory = suggestionBeanFactory;
        this.authenticationContext = authenticationContext;
        this.projectHistoryManager = projectHistoryManager;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
    }

    public List<SuggestionGroupBean> getProjectPickerSuggestions(Optional<Long> selectedProject, boolean includeRecent) {
        return this.getSuggestionGroupBeans(Optional.empty(), selectedProject, includeRecent);
    }

    public List<SuggestionGroupBean> getProjectPickerSuggestions(ProjectPermissionKey permission, Optional<Long> selectedProject, boolean includeRecent) {
        return this.getSuggestionGroupBeans(Optional.of(permission), selectedProject, includeRecent);
    }

    private List<SuggestionGroupBean> getSuggestionGroupBeans(Optional<ProjectPermissionKey> permission, Optional<Long> selectedProject, boolean includeRecent) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        ArrayList suggestions = Lists.newArrayListWithCapacity((int)2);
        if (includeRecent) {
            List<Project> recentProjects = this.getRecentProjects(user, permission);
            suggestions.add(new SuggestionGroupBean(i18n.getText("menu.project.recent"), this.suggestionBeanFactory.projectSuggestions(recentProjects, selectedProject)));
        }
        suggestions.add(new SuggestionGroupBean(i18n.getText("menu.project.all"), this.suggestionBeanFactory.projectSuggestions(this.getAllowedProjects(user, permission), selectedProject)));
        return suggestions;
    }

    private List<Project> getAllowedProjects(ApplicationUser user, Optional<ProjectPermissionKey> permission) {
        return permission.map(projectPermission -> ImmutableList.copyOf((Collection)this.permissionManager.getProjects(projectPermission, user))).orElse(this.projectManager.getProjectObjects());
    }

    private List<Project> getRecentProjects(ApplicationUser user, Optional<ProjectPermissionKey> permission) {
        List<Project> recentProjects = permission.map(projectPermission -> this.projectHistoryManager.getProjectHistoryWithPermissionChecks(this.toLegacyId((ProjectPermissionKey)projectPermission).intValue(), user)).orElse(this.getRecentProjects(user));
        return recentProjects.subList(0, Math.min(6, recentProjects.size()));
    }

    private List<Project> getRecentProjects(ApplicationUser user) {
        return (List)StreamSupport.stream(this.projectHistoryManager.getProjectHistoryWithoutPermissionChecks(user).spliterator(), false).map(userHistoryItem -> this.projectManager.getProjectObj(Long.valueOf(userHistoryItem.getEntityId()))).filter(project -> project != null).collect(CollectorsUtil.toImmutableList());
    }

    private Integer toLegacyId(ProjectPermissionKey permission) {
        return LegacyProjectPermissionKeyMapping.getId(permission);
    }
}

