/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItemImpl;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import java.util.Collection;
import java.util.Map;
import webwork.action.Action;

public class BulkFieldScreenRenderLayoutItemImpl
implements FieldScreenRenderLayoutItem {
    private final Collection<FieldLayoutItem> fieldLayoutItems;
    private final FieldManager fieldManager;
    private final HackyFieldRendererRegistry hackyFieldRendererRegistry;
    private final FieldScreenLayoutItem fieldScreenLayoutItem;

    BulkFieldScreenRenderLayoutItemImpl(FieldManager fieldManager, HackyFieldRendererRegistry hackyFieldRendererRegistry, FieldScreenLayoutItem fieldScreenLayoutItem, Collection<FieldLayoutItem> fieldLayoutItems) {
        this.fieldManager = fieldManager;
        this.hackyFieldRendererRegistry = hackyFieldRendererRegistry;
        this.fieldScreenLayoutItem = fieldScreenLayoutItem;
        this.fieldLayoutItems = fieldLayoutItems;
    }

    public FieldScreenLayoutItem getFieldScreenLayoutItem() {
        return this.fieldScreenLayoutItem;
    }

    public Collection<FieldLayoutItem> getFieldLayoutItems() {
        return this.fieldLayoutItems;
    }

    public String getEditHtml(Action action, OperationContext operationContext, Collection<Issue> issues, Map displayParameters) {
        Issue issue2 = null;
        for (Issue issue2 : issues) {
            if (this.isShow(issue2)) continue;
            return "";
        }
        return this.fieldScreenLayoutItem.getOrderableField().getEditHtml(this.createBulkFieldLayoutItem(), operationContext, action, issue2, displayParameters);
    }

    public String getViewHtml(Action action, OperationContext operationContext, Collection<Issue> issues, Map<String, ?> displayParameters) {
        Issue issue2 = null;
        for (Issue issue2 : issues) {
            if (this.isShow(issue2)) continue;
            return "";
        }
        return this.fieldScreenLayoutItem.getOrderableField().getViewHtml(this.createBulkFieldLayoutItem(), action, issue2, displayParameters);
    }

    public OrderableField getOrderableField() {
        return this.fieldScreenLayoutItem.getOrderableField();
    }

    public boolean isRequired() {
        for (FieldLayoutItem fieldLayoutItem : this.fieldLayoutItems) {
            if (!fieldLayoutItem.isRequired()) continue;
            return true;
        }
        return false;
    }

    public boolean isShow(Issue issue) {
        if (this.fieldScreenLayoutItem != null && !this.fieldScreenLayoutItem.isShown(issue)) {
            return false;
        }
        for (FieldLayoutItem fieldLayoutItem : this.fieldLayoutItems) {
            if (!fieldLayoutItem.isHidden()) continue;
            return false;
        }
        return true;
    }

    private FieldLayoutItem createBulkFieldLayoutItem() {
        FieldLayoutItem fieldLayoutItem = this.fieldLayoutItems.iterator().next();
        OrderableField orderableField = fieldLayoutItem.getOrderableField();
        FieldLayoutItemImpl.Builder builder = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setFieldDescription(null).setRequired(this.isRequired());
        if (!this.hackyFieldRendererRegistry.shouldOverrideDefaultRenderers(orderableField) && !this.fieldManager.isRenderableField((Field)orderableField)) {
            builder.setRendererType("jira-text-renderer");
        }
        return builder.build();
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        throw new UnsupportedOperationException("This method is not available for BulkFieldScreenRenderLayoutItem");
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        throw new UnsupportedOperationException("This method is not available for BulkFieldScreenRenderLayoutItem");
    }

    public String getRendererType() {
        throw new UnsupportedOperationException("This method is not available for BulkFieldScreenRenderLayoutItem");
    }

    public FieldLayoutItem getFieldLayoutItem() {
        throw new UnsupportedOperationException("This method is not available for BulkFieldScreenRenderLayoutItem");
    }

    public String getEditHtml(Action action, OperationContext operationContext, Issue issue) {
        throw new UnsupportedOperationException("This method is not available for BulkFieldScreenRenderLayoutItem");
    }

    public String getCreateHtml(Action action, OperationContext operationContext, Issue issue) {
        throw new UnsupportedOperationException("This method is not available for BulkFieldScreenRenderLayoutItem");
    }

    public String getViewHtml(Action action, OperationContext operationContext, Issue issue) {
        throw new UnsupportedOperationException("This method is not available for BulkFieldScreenRenderLayoutItem");
    }

    public String getCreateHtml(Action action, OperationContext operationContext, Issue issue, Map<String, Object> displayParams) {
        throw new UnsupportedOperationException("This method is not available for BulkFieldScreenRenderLayoutItem");
    }

    public String getEditHtml(Action action, OperationContext operationContext, Issue issue, Map<String, Object> displayParams) {
        throw new UnsupportedOperationException("This method is not available for BulkFieldScreenRenderLayoutItem");
    }

    public String getViewHtml(Action action, OperationContext operationContext, Issue issue, Map<String, Object> displayParams) {
        throw new UnsupportedOperationException("This method is not available for BulkFieldScreenRenderLayoutItem");
    }
}

