/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.EntityWithVersion;
import com.atlassian.jira.issue.index.IndexingLimitsStats;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.versioning.EntityVersioningManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultWorklogRetriever
implements DefaultIssueIndexer.WorklogRetriever {
    private final JiraProperties jiraProperties;
    private final EntityVersioningManager entityVersioningManager;
    private final IndexingLimitsStats indexingLimitsStats;

    public DefaultWorklogRetriever(JiraProperties jiraProperties, EntityVersioningManager entityVersioningManager, IndexingLimitsStats indexingLimitsStats) {
        this.jiraProperties = jiraProperties;
        this.entityVersioningManager = entityVersioningManager;
        this.indexingLimitsStats = indexingLimitsStats;
        this.indexingLimitsStats.settingMaxWorklogsIndexed(this.getWorklogsIndexingLimit());
    }

    @Override
    public List<EntityWithVersion<Worklog>> retrieve(EntityWithVersion<Issue> issueWithVersion) {
        Map<Long, Long> worklogIdToWorklogVersion = this.entityVersioningManager.getRelatedWorklogVersions(issueWithVersion.getEntity().getId());
        List worklogs = ComponentAccessor.getWorklogManager().getByIssue(issueWithVersion.getEntity());
        int limit = this.getWorklogsIndexingLimit();
        this.indexingLimitsStats.settingMaxWorklogsIndexed(limit);
        this.indexingLimitsStats.worklogs(worklogs.size(), limit >= 0 && worklogs.size() > limit, issueWithVersion.getEntity().getKey());
        Stream<EntityWithVersion> sortedWorklogs = worklogs.stream().map(w -> new EntityWithVersion<Worklog>((Worklog)w, worklogIdToWorklogVersion.getOrDefault(w.getId(), EntityDocumentFactory.ENTITY_VERSION_ZERO))).sorted(new EntityWithWorklogComparator().reversed());
        if (limit < 0) {
            return sortedWorklogs.collect(Collectors.toList());
        }
        return sortedWorklogs.limit(limit).collect(Collectors.toList());
    }

    @Override
    public Optional<Worklog> retrieveById(Long worklogId) {
        return Optional.ofNullable(ComponentAccessor.getWorklogManager().getById(worklogId));
    }

    private Integer getWorklogsIndexingLimit() {
        return this.jiraProperties.getInteger("jira.safeguards.indexing.issue.worklogs", Integer.valueOf(100));
    }

    static class EntityWithWorklogComparator
    implements Comparator<EntityWithVersion<Worklog>> {
        EntityWithWorklogComparator() {
        }

        @Override
        public int compare(EntityWithVersion<Worklog> o1, EntityWithVersion<Worklog> o2) {
            int dateCompareResult = o1.getEntity().getUpdated().compareTo(o2.getEntity().getUpdated());
            return dateCompareResult != 0 ? dateCompareResult : o1.getEntity().getId().compareTo(o2.getEntity().getId());
        }
    }
}

