/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Indexes;
import javax.annotation.Nonnull;

public interface IndexingMode {
    public static final IndexingMode DIRECT = new DirectIndexingMode();
    public static final IndexingMode QUEUED = new QueuedIndexingMode();

    @Nonnull
    public Index.Manager createIndexManager(String var1, Configuration var2, ApplicationProperties var3);

    public static class QueuedIndexingMode
    implements IndexingMode {
        @Override
        @Nonnull
        public Index.Manager createIndexManager(String name, Configuration configuration, ApplicationProperties applicationProperties) {
            int maxQueueSize = PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.issue.maxqueuesize", (int)4000);
            return Indexes.createQueuedIndexManager(name, configuration, maxQueueSize);
        }
    }

    public static class DirectIndexingMode
    implements IndexingMode {
        @Override
        @Nonnull
        public Index.Manager createIndexManager(String name, Configuration configuration, ApplicationProperties applicationProperties) {
            return Indexes.createSimpleIndexManager(name, configuration);
        }
    }
}

