/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.IndexingStatsEventPublisher;
import com.atlassian.jira.issue.index.IndexingStatsMetrics;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.ReindexAllCancelledEvent;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.atlassian.jira.issue.index.ReindexAllStartedEvent;
import com.atlassian.jira.issue.index.indexers.FieldIndexerStats;
import com.atlassian.jira.issue.index.indexers.FieldIndexerStatsCollector;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.index.managers.NonNullCustomFieldProviderManager;
import com.atlassian.jira.issue.index.managers.NonNullCustomFieldProviderStats;
import com.atlassian.jira.issue.index.managers.NonNullCustomFieldProviderStatsCollector;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingStatsManager {
    private static final Logger log = LoggerFactory.getLogger(IndexingStatsManager.class);
    private static final String LOG_PREFIX = "[indexing-stats]";
    private static final int MIN_AVG_THRESHOLD_MICROS = 1000;
    private final FieldIndexerManager fieldIndexerManager;
    private final NonNullCustomFieldProviderManager nonNullCustomFieldProviderManager;
    private final CustomFieldManager customFieldManager;
    private final IssueIndexer issueIndexer;
    private final ScheduledExecutorService executorService;
    private final IndexingStatsEventPublisher indexingStatsEventPublisher;

    public IndexingStatsManager(FieldIndexerManager fieldIndexerManager, CustomFieldManager customFieldManager, IssueIndexer issueIndexer, EventPublisher eventPublisher, IndexingStatsEventPublisher indexingStatsEventPublisher, NonNullCustomFieldProviderManager nonNullCustomFieldProviderManager) {
        this.fieldIndexerManager = fieldIndexerManager;
        this.customFieldManager = customFieldManager;
        this.issueIndexer = issueIndexer;
        this.indexingStatsEventPublisher = indexingStatsEventPublisher;
        eventPublisher.register((Object)this);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("indexing-stats-%d").build());
        this.nonNullCustomFieldProviderManager = nonNullCustomFieldProviderManager;
    }

    private Integer getNumberOfIndexingThreads() {
        return this.issueIndexer instanceof DefaultIssueIndexer ? Integer.valueOf(((DefaultIssueIndexer)this.issueIndexer).getNumberOfIndexingThreads()) : null;
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        long periodInMin = JiraStats.statsLoggingInterval(TimeUnit.MINUTES);
        log.info("{} stats will be running every: {} min", (Object)LOG_PREFIX, (Object)periodInMin);
        this.executorService.scheduleAtFixedRate(this::onPeriodicStats, 0L, periodInMin, TimeUnit.MINUTES);
    }

    @EventListener
    public void onPluginFrameworkShutdown(PluginFrameworkShutdownEvent event) {
        this.executorService.shutdownNow();
    }

    @EventListener
    public void onReindexAllStarted(ReindexAllStartedEvent reindexAllStartedEvent) {
        this.resetStats();
    }

    @EventListener
    public void onReindexAllCompleted(ReindexAllCompletedEvent reindexAllCompletedEvent) {
        this.onReindexCompletedStats(reindexAllCompletedEvent.getTotalTime());
    }

    @EventListener
    public void onReindexAllCancelled(ReindexAllCancelledEvent reindexAllCancelledEvent) {
        this.onPeriodicStats();
    }

    private synchronized void resetStats() {
        log.info("{} Resetting stats.", (Object)LOG_PREFIX);
        this.fieldIndexerManager.getIssueIndexerStatsCollectors().forEach(FieldIndexerStatsCollector::resetStats);
        this.nonNullCustomFieldProviderManager.resetStats();
    }

    private synchronized Collection<FieldIndexerStats> fieldIndexersStatsAndResetSnapshot() {
        return this.getFieldIndexersStats(FieldIndexerStatsCollector::getStatsAndResetSnapshot, NonNullCustomFieldProviderStatsCollector::getStatsAndResetSnapshot);
    }

    private synchronized Collection<FieldIndexerStats> getFieldIndexersStats(Function<FieldIndexerStatsCollector, FieldIndexerStats> fieldIndexerStatsFunction, Function<NonNullCustomFieldProviderStatsCollector, NonNullCustomFieldProviderStats> nonNullCustomFieldProviderStatsFunction) {
        return this.fieldIndexerManager.getIssueIndexerStatsCollectors().stream().map(fieldIndexerStatsFunction).map(stats -> this.nonNullCustomFieldProviderManager.getNonNullCustomFieldProviderStatsCollector(stats.id()).map(nonNullCustomFieldProviderStatsFunction).map(stats::mergeStats).orElse((FieldIndexerStats)stats)).collect(Collectors.toSet());
    }

    synchronized void onReindexCompletedStats(long totalIndexingTimeMillis) {
        try {
            Function<FieldIndexerStats, LongStats> totalTimeToAddFunction = FieldIndexerStats::totalTimeToAddIndexMicros;
            List fieldIndexersStatsOrdered = this.fieldIndexersStatsAndResetSnapshot().stream().filter(stats -> ((LongStats)totalTimeToAddFunction.apply((FieldIndexerStats)stats)).sum() > 0L).sorted(Comparator.comparing(totalTimeToAddFunction, Comparator.comparing(LongStats::sum)).reversed()).collect(Collectors.toList());
            Integer numberOfIndexingThreads = this.getNumberOfIndexingThreads();
            for (int i = 0; i < fieldIndexersStatsOrdered.size(); ++i) {
                FieldIndexerStats stats2 = (FieldIndexerStats)fieldIndexersStatsOrdered.get(i);
                LongStats totalTimeToAddLongStats = totalTimeToAddFunction.apply(stats2);
                String messagePrefix = String.format("order:%d, name:%s, isKnown:%b", i + 1, this.fieldName(stats2), stats2.isKnown());
                String messageAddIndex = String.format("addIndex: {sum:%dms, avg:%.1fms, max:%dms, count:%d}", TimeUnit.MICROSECONDS.toMillis(totalTimeToAddLongStats.sum()), (double)totalTimeToAddLongStats.avg() / 1000.0, TimeUnit.MICROSECONDS.toMillis(totalTimeToAddLongStats.max()), totalTimeToAddLongStats.count());
                String messageIndexTime = String.format("totalIndexTime:%dms, addIndexSum/totalIndexTime:%.1f%%, numberOfIndexingThreads:%d", totalIndexingTimeMillis, 100.0 * (double)TimeUnit.MICROSECONDS.toMillis(totalTimeToAddLongStats.sum()) / (double)totalIndexingTimeMillis, numberOfIndexingThreads);
                String message = String.format("{%s, %s, %s}", messagePrefix, messageAddIndex, messageIndexTime);
                log.info("{} field indexing cost: {}", (Object)LOG_PREFIX, (Object)message);
            }
            this.indexingStatsEventPublisher.publishSlowIndexersStats((Iterable<FieldIndexerStats>)this.getSlowIndexersStats());
        }
        catch (Exception e) {
            log.error("{} Error when getting indexing stats after full reindex: {}", new Object[]{LOG_PREFIX, e.getMessage(), e});
        }
    }

    public synchronized void onPeriodicStats() {
        try {
            Collection<FieldIndexerStats> fieldIndexerStats = this.fieldIndexersStatsAndResetSnapshot();
            if (fieldIndexerStats.stream().anyMatch(stats -> stats.snapshotTimeToAddIndexMicros().count() > 0L)) {
                int topN = 10;
                this.printTopTimeToAddIndex(fieldIndexerStats, "total", FieldIndexerStats::totalTimeToAddIndexMicros, 10);
                this.printTopTimeToAddIndex(fieldIndexerStats, "snapshot", FieldIndexerStats::snapshotTimeToAddIndexMicros, 10);
                IndexingStatsMetrics total = this.getStats(fieldIndexerStats, "total", FieldIndexerStats::totalTimeToAddIndexMicros, 10);
                IndexingStatsMetrics snapshot = this.getStats(fieldIndexerStats, "snapshot", FieldIndexerStats::snapshotTimeToAddIndexMicros, 10);
                this.indexingStatsEventPublisher.publish(total, snapshot);
            }
        }
        catch (Throwable throwable) {
            log.error("{} Error when getting periodic indexing stats: {}", new Object[]{LOG_PREFIX, throwable.getMessage(), throwable});
        }
    }

    private Set<FieldIndexerStats> getSlowIndexersStats() {
        Collection<FieldIndexerStats> fieldIndexerStats = this.getFieldIndexersStats(FieldIndexerStatsCollector::getStats, NonNullCustomFieldProviderStatsCollector::getStats);
        long totalAvgTime = fieldIndexerStats.stream().mapToLong(stats -> stats.totalTimeToAddIndexMicros().avg()).sum();
        long threshold = Math.max(totalAvgTime / 100L, 1000L);
        return fieldIndexerStats.stream().filter(stats -> stats.totalTimeToAddIndexMicros().avg() > threshold).collect(Collectors.toSet());
    }

    private void printTopTimeToAddIndex(Collection<FieldIndexerStats> fieldIndexerStats, String statsName, Function<FieldIndexerStats, LongStats> longStatsFunction, int topN) {
        long totalSumMicros = fieldIndexerStats.stream().mapToLong(stats -> ((LongStats)longStatsFunction.apply((FieldIndexerStats)stats)).sum()).sum();
        String topTotalTimeToAddHeader = String.format("noFieldIndexers: %d, sum: %dms", fieldIndexerStats.size(), TimeUnit.MICROSECONDS.toMillis(totalSumMicros));
        String topTotalTimeToAdd = fieldIndexerStats.stream().filter(stats -> ((LongStats)longStatsFunction.apply((FieldIndexerStats)stats)).sum() > 0L).sorted(Comparator.comparing(longStatsFunction, Comparator.comparing(LongStats::sum)).reversed()).limit(topN).map(stats -> String.format("{field: %s, addIndex: {sum/allSum:%.1f%%, sum:%dms, avg:%.1fms, max:%dms, count:%d}}", this.fieldName((FieldIndexerStats)stats), 100.0 * (double)((LongStats)longStatsFunction.apply((FieldIndexerStats)stats)).sum() / (double)totalSumMicros, TimeUnit.MICROSECONDS.toMillis(((LongStats)longStatsFunction.apply((FieldIndexerStats)stats)).sum()), (double)((LongStats)longStatsFunction.apply((FieldIndexerStats)stats)).avg() / 1000.0, TimeUnit.MICROSECONDS.toMillis(((LongStats)longStatsFunction.apply((FieldIndexerStats)stats)).max()), ((LongStats)longStatsFunction.apply((FieldIndexerStats)stats)).count())).collect(Collectors.joining(", "));
        log.info("[JIRA-STATS] {} Top {} addIndex {} ({}): [{}]", new Object[]{LOG_PREFIX, topN, statsName, topTotalTimeToAddHeader, topTotalTimeToAdd});
    }

    private String fieldName(FieldIndexerStats stats) {
        CustomField customField;
        if (!stats.isKnown() && (customField = this.customFieldManager.getCustomFieldObject(stats.id())) != null) {
            return String.format("%s (%s)", stats.id(), customField.getFieldName());
        }
        return stats.id();
    }

    private IndexingStatsMetrics getStats(Collection<FieldIndexerStats> fieldIndexerStats, String statsName, Function<FieldIndexerStats, LongStats> longStatsFunction, int topN) {
        long totalSumMicros = fieldIndexerStats.stream().mapToLong(stats -> ((LongStats)longStatsFunction.apply((FieldIndexerStats)stats)).sum()).sum();
        Date updated = new Date();
        List sortedTop10 = fieldIndexerStats.stream().filter(stats -> ((LongStats)longStatsFunction.apply((FieldIndexerStats)stats)).sum() > 0L).sorted(Comparator.comparing(longStatsFunction, Comparator.comparing(LongStats::sum)).reversed()).limit(topN).collect(Collectors.toList());
        ImmutableMap.Builder statsForEventBuilder = ImmutableMap.builder();
        for (FieldIndexerStats stats2 : sortedTop10) {
            String fieldName = this.fieldName(stats2);
            IndexingStatsMetrics.Metric indexingStatsMetrics = new IndexingStatsMetrics.Metric(fieldName, stats2.id(), 100.0 * (double)longStatsFunction.apply(stats2).sum() / (double)totalSumMicros, (double)longStatsFunction.apply(stats2).avg() / 1000.0, TimeUnit.MICROSECONDS.toMillis(longStatsFunction.apply(stats2).max()), longStatsFunction.apply(stats2).count(), stats2.isKnown());
            statsForEventBuilder.put((Object)fieldName, (Object)indexingStatsMetrics);
        }
        return new IndexingStatsMetrics(statsName, updated, (ImmutableMap<String, IndexingStatsMetrics.Metric>)statsForEventBuilder.build());
    }
}

