/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.issue.index.indexers.FieldIndexerStats;
import com.atlassian.jira.issue.index.indexers.FieldIndexerWithStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@EventName(value="reindex.all.slow.indexers")
public class ReindexAllSlowIndexersEvent {
    private final Map<String, List<Object>> metrics = new HashMap<String, List<Object>>();

    @Deprecated
    public ReindexAllSlowIndexersEvent(Set<FieldIndexerWithStats.Stats> stats) {
        this((Iterable<? extends FieldIndexerStats>)stats);
    }

    public ReindexAllSlowIndexersEvent(Iterable<? extends FieldIndexerStats> stats) {
        this.metrics.put("indexer", new ArrayList());
        this.metrics.put("customField", new ArrayList());
        this.metrics.put("customFieldID", new ArrayList());
        this.metrics.put("declaresNullHandling", new ArrayList());
        this.metrics.put("declaresNonNullValueProvider", new ArrayList());
        this.metrics.put("indexingTotalTime", new ArrayList());
        this.metrics.put("indexingIterations", new ArrayList());
        stats.forEach(s -> {
            this.metrics.get("indexer").add(this.hashValue(s.getIndexerClassName()));
            this.metrics.get("customField").add(this.hashValue(s.getCustomFieldTypeClassName()));
            this.metrics.get("customFieldID").add(this.sanitizeValue(s.getCustomFieldID()));
            this.metrics.get("declaresNullHandling").add(this.sanitizeValue(s.getDeclaresNullHandling()));
            this.metrics.get("declaresNonNullValueProvider").add(this.sanitizeValue(s.getDeclaresNonNullValueProvider()));
            this.metrics.get("indexingTotalTime").add(s.totalTimeToAddIndexMicros().sum());
            this.metrics.get("indexingIterations").add(s.totalTimeToAddIndexMicros().count());
        });
    }

    private Object sanitizeValue(Object value) {
        return value != null ? value : "null";
    }

    private Object hashValue(String value) {
        return value != null ? Integer.valueOf(value.hashCode()) : "null";
    }

    public Map<String, List<Object>> getMetrics() {
        return this.metrics;
    }
}

