/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.managers;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.CustomFieldIndexerWithStats;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.FieldIndexerWithStats;
import com.atlassian.jira.issue.index.managers.CustomFieldIndexerAdapter;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

final class FieldIndexerLoader {
    private final IssueSearcherManager searcherManager;

    FieldIndexerLoader(IssueSearcherManager searcherManager) {
        this.searcherManager = searcherManager;
    }

    public Set<FieldIndexerWithStats> loadSystemFieldIndexers() {
        return (Set)this.getAllSearcherInfo().flatMap(info -> this.extractSystemFieldIndexers((SearcherInformation<?>)info)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<CustomFieldIndexerWithStats> loadCustomFieldIndexers() {
        return (Set)this.getAllSearcherInfo().flatMap(info -> this.extractCustomFieldIndexers((SearcherInformation<?>)info)).collect(ImmutableSet.toImmutableSet());
    }

    private Stream<? extends SearcherInformation<?>> getAllSearcherInfo() {
        return this.searcherManager.getAllSearchers().stream().map(IssueSearcher::getSearchInformation);
    }

    private Stream<FieldIndexerWithStats> extractSystemFieldIndexers(SearcherInformation<?> info) {
        if (this.getCustomField(info).isPresent()) {
            return Stream.empty();
        }
        return info.getRelatedIndexers().stream().map(FieldIndexerWithStats::createOther);
    }

    private Stream<CustomFieldIndexerWithStats> extractCustomFieldIndexers(SearcherInformation<?> info) {
        return this.getCustomField(info).map(customField -> info.getRelatedIndexers().stream().map(indexer -> new CustomFieldIndexerWithStats(new CustomFieldIndexerAdapter((FieldIndexer)indexer, (CustomField)customField)))).orElseGet(Stream::empty);
    }

    private Optional<CustomField> getCustomField(SearcherInformation<?> info) {
        return Optional.ofNullable(info.getField()).filter(CustomField.class::isInstance).map(CustomField.class::cast);
    }
}

