/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.issuetype;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import org.ofbiz.core.entity.GenericValue;

public class IssueTypeImpl
extends IssueConstantImpl
implements IssueType {
    public static final String AVATAR_FIELD = "avatar";
    private final AvatarManager avatarManager;

    public IssueTypeImpl(GenericValue genericValue, TranslationManager translationManager, JiraAuthenticationContext authenticationContext, BaseUrl locator, AvatarManager avatarManager) {
        super(genericValue, translationManager, authenticationContext, locator);
        this.avatarManager = avatarManager;
    }

    public boolean isSubTask() {
        return "jira_subtask".equals(this.genericValue.getString("style"));
    }

    public Avatar getAvatar() {
        Long avatarId = this.getAvatarId();
        return avatarId != null ? this.getAvatarOrDefault(avatarId) : null;
    }

    private Avatar getAvatarOrDefault(Long avatarId) {
        Avatar assignedAvatar = this.avatarManager.getById(avatarId);
        if (null == assignedAvatar) {
            assignedAvatar = this.avatarManager.getById(this.avatarManager.getDefaultAvatarId(Avatar.Type.ISSUETYPE));
        }
        return assignedAvatar;
    }

    public String getType() {
        if (this.isSubTask()) {
            return "Sub-Task";
        }
        return "Standard";
    }

    public Long getAvatarId() {
        return this.genericValue.getLong(AVATAR_FIELD);
    }

    public void setAvatarId(Long avatarId) {
        this.genericValue.set(AVATAR_FIELD, (Object)avatarId);
    }
}

