/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.managers.ArchivingDao;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;

public class DefaultArchivingDao
implements ArchivingDao {
    private final QueryDslAccessor queryDslAccessor;
    private final OfBizDelegator ofBizDelegator;

    public DefaultArchivingDao(QueryDslAccessor queryDslAccessor, OfBizDelegator ofBizDelegator) {
        this.queryDslAccessor = queryDslAccessor;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public long getActiveIssueCount() {
        return this.ofBizDelegator.getCountByAnd("Issue", DefaultArchivingDao.getIsNotArchivedIssueExpression());
    }

    @Override
    public long archiveIssuesInProject(Project project) {
        return this.queryDslAccessor.withNewConnection().executeQuery(connection -> connection.update((RelationalPath<?>)QIssue.ISSUE).set((Path)QIssue.ISSUE.archived, (Object)DatabaseUtil.booleanToChar1(true)).where((Predicate)QIssue.ISSUE.project.eq((Object)project.getId()).and((Predicate)QIssue.ISSUE.archived.eq((Object)DatabaseUtil.booleanToChar1(false)).or((Predicate)QIssue.ISSUE.archived.isNull()))).execute());
    }

    @Override
    public long restoreIssuesInProject(Project project) {
        return this.queryDslAccessor.withNewConnection().executeQuery(connection -> connection.update((RelationalPath<?>)QIssue.ISSUE).set((Path)QIssue.ISSUE.archived, (Object)DatabaseUtil.booleanToChar1(false)).where((Predicate)QIssue.ISSUE.project.eq((Object)project.getId()).and((Predicate)QIssue.ISSUE.archived.eq((Object)DatabaseUtil.booleanToChar1(true))).and((Predicate)QIssue.ISSUE.archivedby.isNull()).and((Predicate)QIssue.ISSUE.archiveddate.isNull())).execute());
    }

    static EntityCondition getIsNotArchivedIssueExpression() {
        return new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr("archived", EntityOperator.EQUALS, (Object)DatabaseUtil.booleanToChar1(false)), (Object)new EntityExpr("archived", EntityOperator.EQUALS, null)), EntityOperator.OR);
    }
}

