/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.issue.search.JiraDocValues;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.parameters.lucene.JiraBytesRef;
import com.atlassian.jira.util.RuntimeIOException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;

public class DocValuesReaderCache
implements ReaderCache {
    public JiraDocValues getDocValues(IndexReader indexReader, String field) throws RuntimeIOException {
        List leafReaderContextList = indexReader.leaves();
        if (leafReaderContextList.size() == 1) {
            return this.getDocValues((LeafReaderContext)leafReaderContextList.get(0), field);
        }
        return this.getDocValues(leafReaderContextList, field);
    }

    private JiraDocValues getDocValues(LeafReaderContext leafReaderContext, String field) throws RuntimeIOException {
        return docId -> {
            int leafId = docId - leafReaderContext.docBase;
            try {
                int maxDoc = leafReaderContext.reader().maxDoc();
                if (leafId > maxDoc) {
                    throw new IllegalArgumentException(String.format("DocId is > maxDocs (%d > %d)", leafId, maxDoc));
                }
                SortedDocValues sortedDocValues = leafReaderContext.reader().getSortedDocValues(field);
                if (sortedDocValues != null) {
                    return this.getBinaryDocValues((BinaryDocValues)sortedDocValues, leafId);
                }
                SortedSetDocValues sortedSetDocValues = leafReaderContext.reader().getSortedSetDocValues(field);
                if (sortedSetDocValues != null) {
                    return this.getSortedSetDocValues(sortedSetDocValues, leafId);
                }
                BinaryDocValues binaryDocValues = leafReaderContext.reader().getBinaryDocValues(field);
                if (binaryDocValues != null) {
                    return this.getBinaryDocValues(binaryDocValues, leafId);
                }
                NumericDocValues numericDocValues = leafReaderContext.reader().getNumericDocValues(field);
                if (numericDocValues != null) {
                    return this.getNumericDocValues(numericDocValues, leafId);
                }
                return new JiraBytesRef[0];
            }
            catch (IOException e) {
                String error = String.format("Error when getting JiraDocValues for field: %s for segment: %s for docId: %d / leafId: %d. Error: %s", field, leafReaderContext.toString(), docId, leafId, e.getMessage());
                throw new RuntimeIOException(error, e);
            }
        };
    }

    private JiraDocValues getDocValues(List<LeafReaderContext> leafReaderContextList, String field) throws RuntimeIOException {
        return docId -> {
            int readerIndex = ReaderUtil.subIndex((int)docId, (List)leafReaderContextList);
            LeafReaderContext leafReaderContext = (LeafReaderContext)leafReaderContextList.get(readerIndex);
            return this.getDocValues(leafReaderContext, field).getDocValues(docId);
        };
    }

    private JiraBytesRef[] getBinaryDocValues(BinaryDocValues docValues, int leafDocId) throws IOException {
        if (docValues.advanceExact(leafDocId)) {
            BytesRef value = docValues.binaryValue();
            return new JiraBytesRef[]{new JiraBytesRef(value.bytes, value.offset, value.length)};
        }
        return new JiraBytesRef[0];
    }

    private JiraBytesRef[] getSortedSetDocValues(SortedSetDocValues docValues, int leafDocId) throws IOException {
        if (docValues.advanceExact(leafDocId)) {
            long nextOrd;
            ArrayList<JiraBytesRef> jiraBytesRefs = new ArrayList<JiraBytesRef>();
            while ((nextOrd = docValues.nextOrd()) != -1L) {
                BytesRef next = BytesRef.deepCopyOf((BytesRef)docValues.lookupOrd(nextOrd));
                jiraBytesRefs.add(new JiraBytesRef(next.bytes, next.offset, next.length));
            }
            return jiraBytesRefs.toArray(new JiraBytesRef[jiraBytesRefs.size()]);
        }
        return new JiraBytesRef[0];
    }

    private JiraBytesRef[] getNumericDocValues(NumericDocValues docValues, int leafDocId) throws IOException {
        if (docValues.advanceExact(leafDocId)) {
            long numValue = docValues.longValue();
            return new JiraBytesRef[]{new JiraBytesRef(Long.toString(numValue))};
        }
        return new JiraBytesRef[0];
    }
}

