/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.handlers;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.DefaultClauseHandler;
import com.atlassian.jira.jql.DefaultValuesGeneratingClauseHandler;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.permission.ClauseSanitiser;
import com.atlassian.jira.jql.permission.DefaultClausePermissionHandler;
import com.atlassian.jira.jql.permission.FieldClausePermissionChecker;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.util.ComponentFactory;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
abstract class SimpleSearchHandlerFactory
implements SearchHandlerFactory {
    private final Class<? extends IssueSearcher<SearchableField>> searcherClass;
    private final ClauseContextFactory clauseContextFactory;
    private final ClauseInformation clauseInformation;
    private final ClauseQueryFactory queryFactory;
    private final ClauseSanitiser sanitiser;
    private final ClauseValidator clauseValidator;
    private final ClauseValuesGenerator clauseValuesGenerator;
    private final ComponentFactory componentFactory;
    private final FieldClausePermissionChecker.Factory clausePermissionFactory;

    protected SimpleSearchHandlerFactory(ComponentFactory componentFactory, ClauseInformation information, Class<? extends IssueSearcher<SearchableField>> searcherClass, ClauseQueryFactory queryFactory, ClauseValidator clauseValidator, FieldClausePermissionChecker.Factory clausePermissionFactory, ClauseContextFactory clauseContextFactory, @Nullable ClauseValuesGenerator clauseValuesGenerator) {
        this(componentFactory, information, searcherClass, queryFactory, clauseValidator, clausePermissionFactory, clauseContextFactory, clauseValuesGenerator, null);
    }

    protected SimpleSearchHandlerFactory(ComponentFactory componentFactory, ClauseInformation information, Class<? extends IssueSearcher<SearchableField>> searcherClass, ClauseQueryFactory queryFactory, ClauseValidator clauseValidator, FieldClausePermissionChecker.Factory clausePermissionFactory, ClauseContextFactory clauseContextFactory, @Nullable ClauseValuesGenerator clauseValuesGenerator, @Nullable ClauseSanitiser sanitiser) {
        this.clauseContextFactory = Objects.requireNonNull(clauseContextFactory);
        this.clausePermissionFactory = Objects.requireNonNull(clausePermissionFactory);
        this.queryFactory = Objects.requireNonNull(queryFactory);
        this.clauseValidator = Objects.requireNonNull(clauseValidator);
        this.clauseInformation = Objects.requireNonNull(information);
        this.componentFactory = Objects.requireNonNull(componentFactory);
        this.searcherClass = Objects.requireNonNull(searcherClass);
        this.clauseValuesGenerator = clauseValuesGenerator;
        this.sanitiser = sanitiser;
    }

    @Override
    @Nonnull
    public final SearchHandler createHandler(SearchableField field) {
        Objects.requireNonNull(field);
        IssueSearcher<SearchableField> searcher = this.createSearchableField(this.searcherClass, field);
        Object clauseHandler = this.clauseValuesGenerator == null ? new DefaultClauseHandler(this.clauseInformation, this.queryFactory, this.clauseValidator, this.createClausePermissionHandler((Field)field), this.clauseContextFactory) : new DefaultValuesGeneratingClauseHandler(this.clauseInformation, this.queryFactory, this.clauseValidator, this.createClausePermissionHandler((Field)field), this.clauseContextFactory, this.clauseValuesGenerator);
        SearchHandler.ClauseRegistration registration = new SearchHandler.ClauseRegistration((ClauseHandler)clauseHandler);
        SearchHandler.SearcherRegistration searcherRegistration = new SearchHandler.SearcherRegistration(searcher, registration);
        return new SearchHandler(searcher.getSearchInformation().getRelatedIndexers(), searcherRegistration);
    }

    private IssueSearcher<SearchableField> createSearchableField(Class<? extends IssueSearcher<SearchableField>> searcherClass, SearchableField field) {
        IssueSearcher<SearchableField> searcher = this.componentFactory.createObject(searcherClass, new Object[0]);
        searcher.init(field);
        return searcher;
    }

    private ClausePermissionHandler createClausePermissionHandler(Field field) {
        if (this.sanitiser == null) {
            return new DefaultClausePermissionHandler(this.clausePermissionFactory.createPermissionChecker(field));
        }
        return new DefaultClausePermissionHandler(this.clausePermissionFactory.createPermissionChecker(field), this.sanitiser);
    }
}

