/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers;

import com.atlassian.jira.issue.customfields.searchers.AbstractDateRangeSearcher;
import com.atlassian.jira.issue.customfields.searchers.DateRangeSearcher;
import com.atlassian.jira.issue.customfields.searchers.GroupPickerSearcher;
import com.atlassian.jira.issue.customfields.searchers.UserPickerGroupSearcher;
import com.atlassian.jira.issue.customfields.searchers.UserPickerSearcher;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.impl.AbstractDateSearcher;
import com.atlassian.jira.issue.search.searchers.impl.AbstractRelativeDateSearcher;
import com.atlassian.jira.issue.search.searchers.impl.AssigneeSearcher;
import com.atlassian.jira.issue.search.searchers.impl.ReporterSearcher;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public class IssueSearcherPanelMap {
    private static final ImmutableMap<Class<? extends IssueSearcher>, Panel> SEARCHER_PANEL_MAP;

    public static Panel getPanel(Class<? extends IssueSearcher> issueSearcherClass) {
        if (SEARCHER_PANEL_MAP.containsKey(issueSearcherClass)) {
            return (Panel)((Object)SEARCHER_PANEL_MAP.get(issueSearcherClass));
        }
        for (Map.Entry entry : SEARCHER_PANEL_MAP.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(issueSearcherClass)) continue;
            return (Panel)((Object)entry.getValue());
        }
        return Panel.DETAILS;
    }

    static {
        HashMap<Class<UserPickerSearcher>, Panel> map = new HashMap<Class<UserPickerSearcher>, Panel>();
        map.put(AbstractDateRangeSearcher.class, Panel.DATES);
        map.put(AbstractDateSearcher.class, Panel.DATES);
        map.put(AbstractRelativeDateSearcher.class, Panel.DATES);
        map.put(AssigneeSearcher.class, Panel.PEOPLE);
        map.put(DateRangeSearcher.class, Panel.DATES);
        map.put(GroupPickerSearcher.class, Panel.PEOPLE);
        map.put(ReporterSearcher.class, Panel.PEOPLE);
        map.put(UserPickerGroupSearcher.class, Panel.PEOPLE);
        map.put(UserPickerSearcher.class, Panel.PEOPLE);
        SEARCHER_PANEL_MAP = ImmutableMap.copyOf(map);
    }

    public static enum Panel {
        DATES("common.concepts.dates"),
        DETAILS("viewissue.subheading.issuedetails"),
        PEOPLE("common.concepts.people");

        private final String titleKey;

        private Panel(String titleKey) {
            this.titleKey = titleKey;
        }

        public String getTitleKey() {
            return this.titleKey;
        }
    }
}

